<?php

namespace Elementor;

class About_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-about-one';
    }

    public function get_title(): string
    {
        return esc_html__('Section About V1', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['about-one', 'about', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section_av1',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'av1_sub_title',
            [
                'label' => esc_html__('Sub Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('ABOUT US', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'av1_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Your Logistics Partner on Every Mile.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'av1_desc',
            [
                'label' => esc_html__('Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('We’re more than a freight carrier—we’re your long-term logistics partner. From the first mile to the final destination, our experienced team ensures every shipment is handled with care, precision, and real-time visibility.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'av1_btn_title',
            [
                'label' => esc_html__('Button Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('VIEW CLASS SCHEDULE', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'av1_btn_link',
            [
                'label' => esc_html__('Button Link', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        //about icons list
        $this->start_controls_section(
            'about_list_section_av1',
            [
                'label' => esc_html__('Icon List', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'av1_icon_image',
            [
                'label' => esc_html__('Icon Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'av1_icon_separate_image',
            [
                'label' => esc_html__('Separator Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'av1_icon_title',
            [
                'label' => esc_html__('Icon Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Full Truckload (FTL)', 'trackngo-core'),
            ]
        );
        $repeater->add_control(
            'av1_icon_desc',
            [
                'label' => esc_html__('Icon Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Ideal for high-volume shipments needing dedicated transport.', 'trackngo-core'),

            ]
        );
        $this->add_control(
            'av1_icon_list',
            [
                'label' => esc_html__('Icon List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ av1_icon_title }}}',
            ]
        );
        $this->end_controls_section();

        //content images
        $this->start_controls_section(
            'images_section_av1',
            [
                'label' => esc_html__('Images', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'av1_title_image',
            [
                'label' => esc_html__('Title Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'av1_about_image',
            [
                'label' => esc_html__('About Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        //about icons list
        $this->start_controls_section(
            'av1_counter_section',
            [
                'label' => esc_html__('Counter', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'av1_counter_number',
            [
                'label' => esc_html__('Number', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('10', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'av1_counter_suffix',
            [
                'label' => esc_html__('Suffix', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('+', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'av1_counter_text',
            [
                'label' => esc_html__('Text', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Years of  Experiences', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'av1_counter_bg_image',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();


        // Trackngo_Elementor_Widget_Init instance
        $trackngo_init = \Trackngo_Elementor_Widget_Init::getInstance();

        // Sub Title style
        $trackngo_init->typography_style($this, 'Sub Title', '.section-title h6');

        // Title style
        $trackngo_init->typography_style($this, 'Title', '.section-title h2');

        // Description style
        $trackngo_init->typography_style($this, 'Description', '.about-text');

        //iocn description style
        $trackngo_init->typography_style($this, 'Icon Heading', '.icon-heading');

        //icon description style
        $trackngo_init->typography_style($this, 'Icon Description', '.icon-desc');

        //counter number style
        $trackngo_init->typography_style($this, 'Counter Number', '.about-counter-item h2');

        //counter text style
        $trackngo_init->typography_style($this, 'Counter Text', '.about-counter-item p');

        //button style
        $trackngo_init->button_style($this, 'Main Button', '.main-button .theme-btn');

        //arrow button style
        $trackngo_init->button_style($this, 'Arrow Button', '.main-button .arrow-btn');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $sub_title = $settings['av1_sub_title'];
        $title = $settings['av1_title'];
        $desc = $settings['av1_desc'];
        $btn_title = $settings['av1_btn_title'];
        $btn_link = $settings['av1_btn_link']['url'];

        $title_image = $settings['av1_title_image']['id'];
        $about_image = $settings['av1_about_image']['id'];
        $av1_icon_list = $settings['av1_icon_list'];

        $counter_number = $settings['av1_counter_number'];
        $counter_suffix = $settings['av1_counter_suffix'];
        $counter_text = $settings['av1_counter_text'];
        $counter_bg_image = $settings['av1_counter_bg_image']['id'];
?>
        <section class="about-section section-padding fix">
            <div class="container">
                <div class="about-wrapper">
                    <div class="row g-4 align-items-center">
                        <div class="col-lg-6">
                            <div class="about-content">
                                <div class="section-title mb-0">
                                    <?php if (!empty($sub_title)): ?><h6 class="wow fadeInUp"><?php echo wp_get_attachment_image($title_image, 'full'); ?><?php echo esc_html($sub_title); ?></h6><?php endif; ?>
                                    <?php if (!empty($title)): ?><h2 class="wow fadeInUp" data-wow-delay=".2s"><?php echo esc_html($title); ?></h2><?php endif; ?>
                                </div>
                                <?php if (!empty($desc)): ?><p class="about-text wow fadeInUp" data-wow-delay=".3s"><?php echo esc_html($desc); ?></p><?php endif; ?>
                                <?php
                                if (!empty($av1_icon_list)) {
                                    $delay = 0.4;
                                    foreach ($av1_icon_list as $item) {
                                        $delay += 0.1;
                                ?>
                                        <div class="icon-box wow fadeInUp" data-wow-delay="<?php echo esc_attr($delay); ?>s">
                                            <?php if (!empty($item['av1_icon_image']['id'])): ?>
                                                <div class="icon">
                                                    <?php echo wp_get_attachment_image($item['av1_icon_image']['id'], 'full'); ?>
                                                </div>
                                            <?php endif; ?>
                                            <?php echo wp_get_attachment_image($item['av1_icon_separate_image']['id'], 'full'); ?>
                                            <div class="content">
                                                <?php if (!empty($item['av1_icon_title'])): ?><h4 class="icon-heading"><?php echo esc_html($item['av1_icon_title']); ?></h4><?php endif; ?>
                                                <?php if (!empty($item['av1_icon_desc'])): ?><p class="icon-desc"><?php echo esc_html($item['av1_icon_desc']); ?></p><?php endif; ?>
                                            </div>
                                        </div>
                                    <?php
                                    }
                                }
                                if (!empty($btn_title)) : ?>
                                    <div class="main-button  wow fadeInUp" data-wow-delay=".9s">
                                        <a href="<?php echo esc_url($btn_link); ?>"> <span class="theme-btn"><?php echo esc_html($btn_title); ?></span><span class="arrow-btn"><i class="fa-regular fa-arrow-up-right"></i></span></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-6 wow fadeInUp" data-wow-delay=".3s">
                            <div class="about-image">
                                <?php echo wp_get_attachment_image($about_image, 'full'); ?>
                                <div class="about-count-box">
                                    <?php echo wp_get_attachment_image($counter_bg_image, 'full'); ?>
                                    <div class="about-counter-item">
                                        <?php if (!empty($counter_number)): ?><h2><span class="count"><?php echo esc_html($counter_number); ?></span><?php echo esc_html($counter_suffix); ?></h2><?php endif; ?>
                                        <?php if (!empty($counter_text)): ?><p><?php echo wp_kses_post($counter_text); ?></p><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new About_V1());
