<?php

namespace Elementor;

class About_V2 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-about-two';
    }

    public function get_title(): string
    {
        return esc_html__('Section About V2', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['about-two', 'about', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title_img',
            [
                'label' => esc_html__('Sub Title Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('About Us', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Elevating Air Cargo, One Shipment at a Time', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('With every takeoff, we bring reliability, speed, and precision to your air freight needs. Our expert team manages every detail—from documentation to real-time tracking—ensuring your cargo arrives safely and on time.', 'trackngo-core'),
            ]
        );
        $this->end_controls_section();

        // Author Section
        $this->start_controls_section(
            'content_section_author',
            [
                'label' => esc_html__('Author', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'author_img',
            [
                'label' => esc_html__('Author Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'signature_img',
            [
                'label' => esc_html__('Signature Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'author_name',
            [
                'label' => esc_html__('Author Name', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Tushar Danile', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'author_profession',
            [
                'label' => esc_html__('Author Profession', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('CEO Company', 'trackngo-core'),
            ]
        );
        $this->end_controls_section();

        // tab Section
        $this->start_controls_section(
            'content_section_tab',
            [
                'label' => esc_html__('Tab', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'tab_list',
            [
                'label' => esc_html__('Tab List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'tab_title',
                        'label' => esc_html__('Tab Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Our Mission', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'tab_content',
                        'label' => esc_html__('Content', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => esc_html__('We are committed to providing expert training, supportive community, and a motivating environment where people of all fitness levels can thrive. We believe that fitness is not just a goal — it’s a lifelong journey of growth,', 'trackngo-core'),
                        'show_label' => false,
                    ],
                ],
                'title_field' => '{{{ tab_title }}}',
            ]
        );
        $this->end_controls_section();

        // Images Section
        $this->start_controls_section(
            'content_section_images',
            [
                'label' => esc_html__('Images', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'about_image',
            [
                'label' => esc_html__('About Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape_image_one',
            [
                'label' => esc_html__('Shape Image One', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape_image_two',
            [
                'label' => esc_html__('Shape Image Two', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape_image_three',
            [
                'label' => esc_html__('Shape Image Three', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngo_init = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngo_init->section_style($this, 'Section', '.about-section-2');

        $trackngo_init->typography_style($this, 'Sub Title', '.section-title h6');

        $trackngo_init->typography_style($this, 'Title', '.section-title h2');

        $trackngo_init->typography_style($this, 'Description', '.about-text');

        $trackngo_init->typography_style($this, 'Author Name', '.client-content h4');

        $trackngo_init->typography_style($this, 'Author Profession', '.client-content p');

        $trackngo_init->typography_style($this, 'Tab Title', '.nav .nav-item a');

        $trackngo_init->section_style($this, 'Tab Title Active', '.nav-item .active');

        $trackngo_init->typography_style($this, 'Tab Content', '.about-tab-box p');

        $trackngo_init->section_style($this, 'Tab Content Body', '.about-tab-box');
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $tab_lists = $settings['tab_list'] ?? [];
?>
        <section class="about-section-2 section-padding fix">
            <?php if (!empty($settings['shape_image_one']['id'])): ?>
                <div class="about-shape-1">
                    <?php echo wp_get_attachment_image($settings['shape_image_one']['id'], 'full'); ?>
                </div>
            <?php endif; ?>
            <?php if (!empty($settings['shape_image_two']['id'])): ?>
                <div class="about-shape-2">
                    <?php echo wp_get_attachment_image($settings['shape_image_two']['id'], 'full'); ?>
                </div>
            <?php endif; ?>
            <?php if (!empty($settings['shape_image_three']['id'])): ?>
                <div class="about-shape-3">
                    <?php echo wp_get_attachment_image($settings['shape_image_three']['id'], 'full'); ?>
                </div>
            <?php endif; ?>
            <div class="container">
                <div class="about-wrapper-2">
                    <div class="row g-4 ">
                        <div class="col-lg-6 wow fadeInUp" data-wow-delay=".3s">
                            <?php if (!empty($settings['about_image']['id'])): ?>
                                <div class="about-iamge">
                                    <?php echo wp_get_attachment_image($settings['about_image']['id'], 'full'); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-lg-6">
                            <div class="about-content">
                                <div class="section-title mb-0">
                                    <?php if (!empty($settings['sub_title'])): ?><h6 class="wow fadeInUp"><?php echo wp_get_attachment_image($settings['sub_title_img']['id'], 'full'); ?><?php echo esc_html($settings['sub_title']); ?></h6><?php endif; ?>
                                    <?php if (!empty($settings['title'])): ?><h2 class="wow fadeInUp" data-wow-delay=".2s"><?php echo esc_html($settings['title']); ?></h2><?php endif; ?>
                                </div>
                                <?php if (!empty($settings['description'])): ?><p class="about-text wow fadeInUp" data-wow-delay=".3s"><?php echo esc_html($settings['description']); ?></p><?php endif; ?>
                                <div class="client-info-area">
                                    <div class="client-info wow fadeInUp" data-wow-delay=".5s">
                                        <?php if (!empty($settings['author_img']['id'])): ?>
                                            <div class="client-img">
                                                <?php echo wp_get_attachment_image($settings['author_img']['id'], 'full'); ?>
                                            </div>
                                        <?php endif; ?>
                                        <div class="client-content">
                                            <?php if (!empty($settings['author_name'])): ?><h4><?php echo esc_html($settings['author_name']); ?></h4><?php endif; ?>
                                            <?php if (!empty($settings['author_profession'])): ?><p><?php echo esc_html($settings['author_profession']); ?></p><?php endif; ?>
                                        </div>
                                    </div>
                                    <?php echo wp_get_attachment_image($settings['signature_img']['id'], 'full'); ?>
                                </div>
                                <ul class="nav">
                                    <?php
                                    if (!empty($tab_lists)) :
                                        foreach ($tab_lists as $index => $tab) :
                                            $id = $index + 1;
                                            $active_class = ($index == 1) ? 'active' : '';
                                    ?>
                                            <li class="nav-item">
                                                <a href="#thumb<?php echo esc_attr($id); ?>" data-bs-toggle="tab" class="nav-link <?php echo $active_class ?>">
                                                    <?php echo esc_html($tab['tab_title']); ?>
                                                </a>
                                            </li>
                                    <?php
                                        endforeach;
                                    endif;
                                    ?>
                                </ul>
                                <div class="tab-content">
                                    <?php
                                    if (!empty($tab_lists)) :

                                        foreach ($tab_lists as $index => $tab) :
                                            $id = $index + 1;
                                            $active_class = ($index == 1) ? 'show active' : '';
                                    ?>
                                            <div id="thumb<?php echo esc_attr($id); ?>" class="tab-pane fade <?php echo $active_class ?>">
                                                <div class="about-tab-box">
                                                    <?php if (!empty($tab['tab_content'])): ?><p><?php echo esc_html($tab['tab_content']); ?></p><?php endif; ?>
                                                </div>
                                            </div>
                                    <?php
                                        endforeach;
                                    endif;
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new About_V2());
