<?php

namespace Elementor;

class About_V3 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-about-three';
    }

    public function get_title(): string
    {
        return esc_html__('Section About V3', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['about-three', 'about', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('ABOUT US', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Your Logistics Partner on Every Mile.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'desc',
            [
                'label' => esc_html__('Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('We’re more than a freight carrier—we’re your long-term logistics partner. From the first mile to the final destination, our experienced team ensures every shipment is handled with care, precision, and real-time visibility.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Button Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('VIEW CLASS SCHEDULE', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Button Link', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        //content images
        $this->start_controls_section(
            'icon_box_section',
            [
                'label' => esc_html__('Icon Box', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'icon_title',
            [
                'label' => esc_html__('Our History', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('VIEW CLASS SCHEDULE', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_desc',
            [
                'label' => esc_html__('Icon Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Decades of trusted sea freight experience, navigating global trade with precision and care.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_image',
            [
                'label' => esc_html__('Icon Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        //about icons list
        $this->start_controls_section(
            'about_list_section',
            [
                'label' => esc_html__('Feature List', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'icon_title',
            [
                'label' => esc_html__('Feature Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Full Truckload (FTL)', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_list',
            [
                'label' => esc_html__('Feature List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ icon_title }}}',
            ]
        );
        $this->end_controls_section();

        //content images
        $this->start_controls_section(
            'images_section',
            [
                'label' => esc_html__('Images', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title_image',
            [
                'label' => esc_html__('Title Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'about_image',
            [
                'label' => esc_html__('About Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        //about icons list
        $this->start_controls_section(
            'counter_section',
            [
                'label' => esc_html__('Counter', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'counter_number',
            [
                'label' => esc_html__('Number', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('10', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'counter_suffix',
            [
                'label' => esc_html__('Suffix', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('+', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'counter_text',
            [
                'label' => esc_html__('Text', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Years of  Experiences', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'about_shape_image',
            [
                'label' => esc_html__('Shape Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngo_init = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngo_init->typography_style($this, 'Sub Title', '.section-title h6');

        $trackngo_init->typography_style($this, 'Title', '.section-title h2');

        $trackngo_init->typography_style($this, 'Description', '.about-text');

        $trackngo_init->typography_style($this, 'Icon Box Heading', '.icon-box .content h4');

        $trackngo_init->typography_style($this, 'Icon Box Description', '.icon-box .content p');

        $trackngo_init->section_style($this, 'Icon Box ', '.icon-box .icon');

        $trackngo_init->typography_style($this, 'Feature Item Text', '.about-list ul li');

        $trackngo_init->typography_style($this, 'Counter Number', '.about-counter h3');

        $trackngo_init->typography_style($this, 'Counter Text', '.about-counter p');

        $trackngo_init->button_style($this, 'Main Button', '.main-button .theme-btn');

        $trackngo_init->button_style($this, 'Arrow Button', '.main-button .arrow-btn');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $sub_title = $settings['sub_title'];
        $title = $settings['title'];
        $desc = $settings['desc'];
        $btn_title = $settings['btn_title'];
        $btn_link = $settings['btn_link']['url'];

        $title_image = $settings['title_image']['id'];
        $about_image = $settings['about_image']['id'];
        $icon_list = $settings['icon_list'];

        $icon_title = $settings['icon_title'];
        $icon_desc = $settings['icon_desc'];
        $icon_image = $settings['icon_image']['id'];

        $counter_number = $settings['counter_number'];
        $counter_suffix = $settings['counter_suffix'];
        $counter_text = $settings['counter_text'];
        $about_shape_image = $settings['about_shape_image']['id'];
?>
        <section class="about-section-3 section-padding fix bg-cover" style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>');">
            <div class="container">
                <div class="about-wrapper-3">
                    <div class="row g-4">
                        <div class="col-lg-6 wow fadeInUp" data-wow-delay=".3s">
                            <div class="about-image-items">
                                <?php echo wp_get_attachment_image($about_image, 'full'); ?>
                                <div class="about-counter">
                                    <?php if (!empty($counter_number)): ?><h3><span class="count"><?php echo esc_html($counter_number); ?></span><?php echo esc_html($counter_suffix); ?></h3><?php endif; ?>
                                    <?php if (!empty($counter_text)): ?><p><?php echo wp_kses_post($counter_text); ?></p><?php endif; ?>
                                </div>
                                <?php if (!empty($about_shape_image)): ?>
                                    <div class="about-shape">
                                        <?php echo wp_get_attachment_image($about_shape_image, 'full'); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="about-content">
                                <div class="section-title mb-0">
                                    <?php if (!empty($sub_title)): ?><h6 class="wow fadeInUp"><?php echo wp_get_attachment_image($title_image, 'full'); ?><?php echo esc_html($sub_title); ?></h6><?php endif; ?>
                                    <?php if (!empty($title)): ?><h2 class="wow fadeInUp" data-wow-delay=".2s"><?php echo esc_html($title); ?></h2><?php endif; ?>
                                </div>
                                <?php if (!empty($desc)): ?><p class="about-text wow fadeInUp" data-wow-delay=".3s"><?php echo esc_html($desc); ?></p><?php endif; ?>
                                <div class="icon-box wow fadeInUp" data-wow-delay=".5s">
                                    <?php if (!empty($icon_image)): ?>
                                        <div class="icon">
                                            <?php echo wp_get_attachment_image($icon_image, 'full'); ?>
                                        </div>
                                    <?php endif; ?>
                                    <div class="content">
                                        <?php if (!empty($icon_title)): ?><h4><?php echo esc_html($icon_title); ?></h4><?php endif; ?>
                                        <?php if (!empty($icon_desc)): ?><p><?php echo esc_html($icon_desc); ?></p><?php endif; ?>
                                    </div>
                                </div>
                                <div class="about-list wow fadeInUp" data-wow-delay=".7s">
                                    <ul>
                                        <?php
                                        if (!empty($icon_list)) {
                                            $delay = 0.4;
                                            foreach ($icon_list as $index => $item) {
                                                $delay += 0.1;
                                        ?>
                                                <li>
                                                    <i class="fa-solid fa-circle-arrow-right"></i>
                                                    <?php echo !empty($item['icon_title']) ? esc_html($item['icon_title']) : ''; ?>
                                                </li>
                                        <?php
                                            }
                                        }
                                        ?>
                                    </ul>

                                </div>
                                <?php if (!empty($btn_title)) : ?>
                                    <div class="main-button  wow fadeInUp" data-wow-delay=".9s">
                                        <a href="<?php echo esc_url($btn_link); ?>"> <span class="theme-btn"><?php echo esc_html($btn_title); ?></span><span class="arrow-btn"><i class="fa-regular fa-arrow-up-right"></i></span></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new About_V3());
