<?php

namespace Elementor;

class Accordion extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-accordion';
    }

    public function get_title(): string
    {
        return esc_html__('Accordion', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['accordion', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'items_list',
            [
                'label' => esc_html__('Accordion List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'list_title',
                        'label' => esc_html__('Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('All-Risk Cargo Insurance', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'list_desc',
                        'label' => esc_html__('Description', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => esc_html__('Full protection against loss, damage, theft, or natural events during transit.', 'trackngo-core'),
                        'label_block' => true,
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->typography_style($this, 'Title', '.accordion-header .accordion-button');

        $trackngoElementorInit->section_style($this, 'Title Body', '.accordion-header .accordion-button');

        $trackngoElementorInit->typography_style($this, 'Description', '.accordion-body');

        $trackngoElementorInit->section_style($this, 'Description Body', '.accordion-body');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="service-details-wrapper">
            <div class="faq-content">
                <div class="faq-accordion">
                    <div class="accordion" id="accordion">

                        <?php
                        if (!empty($settings['items_list'])):
                            $delay = 0.2;
                            foreach ($settings['items_list'] as  $index => $item):
                                $delay += 0.1;
                                $id = 'faq' . $index;
                                $show = $index === 1 ? 'show' : 'collapse';
                        ?>
                                <div class="accordion-item mb-4 wow fadeInUp" data-wow-delay="<?php echo esc_attr($delay); ?>s" style="visibility: visible; animation-delay: <?php echo esc_attr($delay); ?>; animation-name: fadeInUp;">
                                    <h5 class="accordion-header">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#<?php echo esc_attr($id); ?>" aria-expanded="true" aria-controls="<?php echo esc_attr($id); ?>"><?php echo esc_html($item['list_title']); ?></button>
                                    </h5>
                                    <div id="<?php echo esc_attr($id); ?>" class="accordion-collapse <?php echo esc_attr($show); ?>" data-bs-parent="#accordion">
                                        <div class="accordion-body"><?php echo esc_html($item['list_desc']); ?></div>
                                    </div>
                                </div>
                        <?php
                            endforeach;
                        endif;
                        ?>

                    </div>
                </div>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Accordion());
