<?php

namespace Elementor;

class Blockquote extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-blockquote';
    }

    public function get_title(): string
    {
        return esc_html__('Blockquote', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['blockquote', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Our team of UI/UX experts conducts a thorough evaluation o the submitted element, analyzing its usability, functionality', 'trackngo-core'),
            ]
        );

        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Body', '.highlight-box');

        $trackngoElementorInit->typography_style($this, 'Title', '.highlight-box p');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="service-details-wrapper">
            <div class="highlight-box">
                <?php if (!empty($settings['title'])) {
                    echo '<p>' . esc_html($settings['title']) . '</p>';
                } ?>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Blockquote());
