<?php

namespace Elementor;

class Blog_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-blog-v1';
    }

    public function get_title(): string
    {
        return esc_html__('Blog V1', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['blog-v1', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'thumb_image',
            [
                'label' => esc_html__('Thumbnail Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'select_post',
            [
                'label' => esc_html__('Select Post', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '-1',
                'options' => trackngo_get_blog(),
            ]
        );
        $this->add_control(
            'blog_style',
            [
                'label' => esc_html__('Choose Style', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'one',
                'options' => [
                    'one' => esc_html__('Style One', 'trackngo-core'),
                    'two' => esc_html__('Style Two', 'trackngo-core'),
                ],
            ]
        );
        $this->add_control(
            'title_word_count',
            [
                'label' => esc_html__('Number of Title Words', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10000,
                'step' => 1,
                'default' => -1,
            ]
        );
        $this->add_control(
            'content_word_count',
            [
                'label' => esc_html__('Number of Content Words', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10000,
                'step' => 1,
                'default' => -1,
            ]
        );
        $this->add_control(
            'show_author',
            [
                'label' => esc_html__('Show Author', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'trackngo-core'),
                'label_off' => esc_html__('Hide', 'trackngo-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_comments',
            [
                'label' => esc_html__('Show Comments', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'trackngo-core'),
                'label_off' => esc_html__('Hide', 'trackngo-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_btn',
            [
                'label' => esc_html__('Show Button', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'trackngo-core'),
                'label_off' => esc_html__('Hide', 'trackngo-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label' => esc_html__('Button Text', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('READ MORE', 'trackngo-core'),
                'condition' => [
                    'show_btn' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();
        $trackngoElementorInit->section_style($this, 'Section', '.news-top-items');
        $trackngoElementorInit->typography_style($this, 'Title', '.news-top-items .news-content h3 a');
        $trackngoElementorInit->typography_style($this, 'Description', '.desc');
        $trackngoElementorInit->typography_style($this, 'Author', '.author');
        $trackngoElementorInit->typography_style($this, 'Comments', '.comments');
        $trackngoElementorInit->button_style($this, 'Button', '.theme-btn');

        // Author & Comments Shape Style
        $this->start_controls_section(
            'author_comments_shape_section',
            [
                'label' => esc_html__('Author & Commentes Shape', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'author_comments_shape_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .news-top-items .news-content ul li::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $blog_id = !empty($settings['select_post']) ? intval($settings['select_post']) : 0;
        $title = get_the_title($blog_id);
        $permalink = get_the_permalink($blog_id);
        $content = get_the_content(null, false, $blog_id);
        $title = wp_trim_words($title, $settings['title_word_count']);
        $content = wp_trim_words($content, $settings['content_word_count']);

        if ($settings['blog_style'] == 'two') {
            $style = 'flex-row-reverse';
            $margin = 'm-0';
        } else {
            $style = '';
        }
?>
        <div class="news-top-items">
            <div class="row g-4 align-items-center <?php echo esc_attr($style); ?>">
                <div class="col-lg-6 wow fadeInUp" data-wow-delay=".3s">
                    <?php if (!empty($settings['thumb_image']['id'])): ?>
                        <div class="news-image">
                            <?php echo wp_get_attachment_image($settings['thumb_image']['id'], 'full'); ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="col-lg-6 wow fadeInUp" data-wow-delay=".5s">
                    <div class="news-content <?php echo esc_attr($margin); ?>">
                        <ul>

                            <?php if ('yes' == $settings['show_author']): ?>
                                <li class="author"> <?php echo get_the_author(); ?> </li>

                            <?php endif;
                            if ('yes' == $settings['show_comments']): ?>
                                <li class="comments">
                                    <?php
                                    $conmment_count = get_comments_number($blog_id);
                                    echo esc_html($conmment_count) . ' ' . esc_html__('Comments', 'trackngo-core');
                                    ?>
                                </li>
                            <?php endif; ?>

                        </ul>
                        <?php if (!empty($title)): ?><h3><a href="<?php echo $permalink; ?>"><?php echo $title; ?></a></h3><?php endif; ?>
                        <div class="desc"><?php echo $content; ?></div>
                        <?php if ('yes' == $settings['show_btn']): ?>
                            <div class="main-button wow fadeInUp" data-wow-delay=".3s">
                                <a href="<?php echo $permalink; ?>"> <span class="theme-btn"> <?php echo esc_html($settings['btn_text']); ?> </span><span class="arrow-btn"><i class="fa-regular fa-arrow-up-right"></i></span></a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
<?php

    }
}
Plugin::instance()->widgets_manager->register(new Blog_V1());
