<?php

namespace Elementor;

class Blog_V3 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-blog-v3';
    }

    public function get_title(): string
    {
        return esc_html__('Blog V3', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['blog-v3', 'blog', 'post', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'thumb_image',
            [
                'label' => esc_html__('Thumbnail Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'select_post',
            [
                'label' => esc_html__('Select Post', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '-1',
                'options' => trackngo_get_blog(),
            ]
        );
        $this->add_control(
            'title_word_count',
            [
                'label' => esc_html__('Number of Title Words', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10000,
                'step' => 1,
                'default' => -1,
            ]
        );
        $this->add_control(
            'show_author',
            [
                'label' => esc_html__('Show Author', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'trackngo-core'),
                'label_off' => esc_html__('Hide', 'trackngo-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_comments',
            [
                'label' => esc_html__('Show Comments', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'trackngo-core'),
                'label_off' => esc_html__('Hide', 'trackngo-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('Show Date', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'trackngo-core'),
                'label_off' => esc_html__('Hide', 'trackngo-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'animation_delay',
            [
                'label' => esc_html__('Animaiton Dealy', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10000,
                'step' => 1,
                'default' => 300,
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Section', '.news-box-items-3');

        $trackngoElementorInit->typography_style($this, 'Title', '.news-box-items-3 .news-content h3 a');

        $trackngoElementorInit->typography_style($this, 'Author', '.author');

        $trackngoElementorInit->typography_style($this, 'Comments', '.comments');

        $trackngoElementorInit->typography_style($this, 'Date', '.post-date span');

        $trackngoElementorInit->section_style($this, 'Date Body', '.post-date span');
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $blog_id = !empty($settings['select_post']) ? intval($settings['select_post']) : 0;
        $title = get_the_title($blog_id);
        $permalink = get_the_permalink($blog_id);
        $title = wp_trim_words($title, $settings['title_word_count']);
?>
        <div class="news-box-items-3 wow animated fadeInUp" data-wow-delay="<?php echo esc_attr($settings['animation_delay']); ?>ms">
            <?php if (!empty($settings['thumb_image']['id'])): ?>
                <div class="news-image">
                    <?php echo wp_get_attachment_image($settings['thumb_image']['id'], 'full'); ?>
                </div>
            <?php endif; ?>
            <div class="news-content">
                <?php if (!empty($title)): ?><h3><a href="<?php echo $permalink; ?>"><?php echo $title; ?></a></h3><?php endif; ?>
                <ul>
                    <?php if ('yes' == $settings['show_author']): ?>
                        <li class="author"> <?php echo get_the_author(); ?> </li>
                    <?php endif;
                    if ('yes' == $settings['show_comments']): ?>
                        <li class="comments">
                            <?php
                            $conmment_count = get_comments_number($blog_id);
                            echo esc_html($conmment_count) . ' ' . esc_html__('Comments', 'trackngo-core');
                            ?>
                        </li>
                    <?php endif; ?>
                </ul>
                <?php if ('yes' == $settings['show_date']): ?>
                    <div class="post-date">
                        <span><?php echo get_the_date('D/M/Y'); ?></span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
<?php

    }
}
Plugin::instance()->widgets_manager->register(new Blog_V3());
