<?php

namespace Elementor;

class Breadcrumb extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-breadcrumb';
    }

    public function get_title(): string
    {
        return esc_html__('Breadcrumb', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['breadcrumb', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            '_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Page Title', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'background_image',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape_Image',
            [
                'label' => esc_html__('Shape Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngo_init = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngo_init->section_style($this, 'Body', '.il-breadcrumb-wrapper');

        $trackngo_init->typography_style($this, 'Title', '.page-heading h1');

        $trackngo_init->typography_style($this, 'Breadcrumb', '.breadcrumb-title a, .breadcrumb-title span');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $title = $settings['_title'];
        $background_image = $settings['background_image']['url'] ?? '';
        $shape_image = $settings['shape_Image']['id'] ?? '';
?>
        <div class="il-breadcrumb-wrapper bg-cover" style="background-image:url('<?php echo esc_url($background_image); ?>');">

            <?php if (! empty($shape_image)) : ?>
                <div class="shape">
                    <?php echo wp_get_attachment_image($shape_image, 'full'); ?>
                </div>
            <?php endif; ?>

            <div class="container">
                <div class="page-heading">

                    <?php if (!empty($title)): ?>
                        <h1 class="pb-3">
                            <?php echo esc_html($title); ?>
                        </h1>
                    <?php endif; ?>

                    <?php if (function_exists('bcn_display')): ?>
                        <div class="breadcrumb-title">
                            <?php bcn_display(); ?>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Breadcrumb());
