<?php

namespace Elementor;

class Hero_Button extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-button';
    }

    public function get_title(): string
    {
        return esc_html__('Button', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['button', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Button Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('READ MORE', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'btn_icon',
            [
                'label' => esc_html__('Button Icon', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa-arrow-up-right',
                    'library' => 'fa-regular',
                ],
                'recommended' => [
                    'fa-solid' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                    'fa-regular' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                ],
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Button Link', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();


        // Aivora_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->button_style($this, 'Button', '.theme-btn');
    }
    protected function render(): void
    {

        $settings = $this->get_settings_for_display();

        if (!empty($settings['btn_title'])) {
            echo '<div class="main-button  wow fadeInUp" data-wow-delay=".9s">';
            echo '<a href="' . esc_url($settings['btn_link']['url']) . '"> <span class="theme-btn"> ' . esc_html($settings['btn_title']) . ' </span><span class="arrow-btn"><i class="' . esc_attr($settings['btn_icon']['library']) . ' ' . esc_attr($settings['btn_icon']['value']) . '"></i></span></a>';
            echo '</div>';
        }
    }
}
Plugin::instance()->widgets_manager->register(new Hero_Button());
