<?php

namespace Elementor;

class Choose_Us extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-choose-us';
    }

    public function get_title(): string
    {
        return esc_html__('Choose Us V1', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['choose-us-v1', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section_images_counter',
            [
                'label' => esc_html__('Images & Counter', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'choose_us_image',
            [
                'label' => esc_html__('Choose Us Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'counter_image',
            [
                'label' => esc_html__('Counter Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape_image',
            [
                'label' => esc_html__('Shape Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'counter_number',
            [
                'label' => esc_html__('Counter Number', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('40', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'counter_suffix',
            [
                'label' => esc_html__('Counter Suffix', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('+ Years', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'counter_desc',
            [
                'label' => esc_html__('Counter Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Working Exprience', 'trackngo-core'),
            ]
        );
        $this->end_controls_section();

        //content
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title_before_img',
            [
                'label' => esc_html__('Sub Title Before Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Why Choose Us', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'main_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Air Freight Backed by Experience', 'trackngo-core'),
            ]
        );
        $this->add_control(
            '_desc',
            [
                'label' => esc_html__('Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('With decades of industry expertise, we deliver precise, secure, and timely air freight solutions—trusted by businesses worldwide.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'list_items',
            [
                'label' => esc_html__('List Items', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'list_icon_img',
                        'label' => esc_html__('Icon Image', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'name' => 'list_title',
                        'label' => esc_html__('Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Express Air Transport', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'list_desc',
                        'label' => esc_html__('Description', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Priority air freight service ensuring your time-sensitive shipments arrive fast, safely', 'trackngo-core'),
                        'label_block' => true,
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );
        $this->end_controls_section();


        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Section', '.choose-us-section-2');

        $trackngoElementorInit->typography_style($this, 'Sub Title', '.IXL-sub-title');

        $trackngoElementorInit->typography_style($this, 'Title', '.IXL-title');

        $trackngoElementorInit->typography_style($this, 'Description', '.IXL-desc');

        $trackngoElementorInit->typography_style($this, 'Counter', '.choose-counter-items span');

        $trackngoElementorInit->typography_style($this, 'Counter Suffix', '.choose-counter-items h2');

        $trackngoElementorInit->typography_style($this, 'Counter Description', '.choose-counter-items p');

        $trackngoElementorInit->section_style($this, 'Counter Body', '.choose-counter-box');

        $trackngoElementorInit->typography_style($this, 'Items Title', '.content h3');

        $trackngoElementorInit->typography_style($this, 'Items Description', '.content p');

        $trackngoElementorInit->section_style($this, 'Active Items Body', '.icon-items.active');
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $list_items = isset($settings['list_items']) ? $settings['list_items'] : [];
?>
        <section class="choose-us-section-2 section-padding fix bg-cover" style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>');">
            <div class="container">
                <div class="choose-wrapper-2">
                    <div class="row">
                        <div class="col-xl-6 wow fadeInUp" data-wow-delay=".3s">
                            <div class="choose-image">
                                <?php echo wp_get_attachment_image($settings['choose_us_image']['id'], 'full'); ?>
                                <div class="choose-counter-box">
                                    <?php if (!empty($settings['counter_image']['id'])): ?>
                                        <div class="image">
                                            <?php echo wp_get_attachment_image($settings['counter_image']['id'], 'full'); ?>
                                        </div>
                                    <?php endif; ?>
                                    <div class="choose-counter-items">
                                        <?php if (!empty($settings['counter_number'])): ?><h2><span class="count"><?php echo esc_html($settings['counter_number']); ?></span><?php echo esc_html($settings['counter_suffix']); ?></h2><?php endif; ?>
                                        <?php if (!empty($settings['counter_desc'])): ?><p><?php echo esc_html($settings['counter_desc']); ?></p><?php endif; ?>
                                    </div>
                                </div>
                                <?php if (!empty($settings['shape_image']['id'])): ?>
                                    <div class="arrow-shape">
                                        <?php echo wp_get_attachment_image($settings['shape_image']['id'], 'full'); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="choose-content mt-4 mt-xl-0">
                                <div class="section-title mb-0">
                                    <?php if (!empty($settings['sub_title'])): ?><h6 class="wow fadeInUp IXL-sub-title"><?php echo wp_get_attachment_image($settings['sub_title_before_img']['id'], 'full'); ?><?php echo esc_html($settings['sub_title']); ?></h6><?php endif; ?>
                                    <?php if (!empty($settings['main_title'])): ?><h2 class="text-white wow fadeInUp IXL-title" data-wow-delay=".2s"><?php echo esc_html($settings['main_title']); ?></h2><?php endif; ?>
                                </div>
                                <?php if (!empty($settings['_desc'])): ?><p class="IXL-desc choose-text wow fadeInUp" data-wow-delay=".3s"><?php echo esc_html($settings['_desc']); ?></p><?php endif; ?>
                                <div class="icon-items-area">
                                    <?php
                                    if (!empty($list_items)) {
                                        $delay = 200;
                                        foreach ($list_items as $index => $item) {
                                            $delay += 200;
                                            $top_one = $index == 0 ? 'mt-0' : '';
                                            $second = $index == 1 ? 'active' : '';
                                    ?>
                                            <div class="icon-items wow fadeInUp <?php echo esc_attr($top_one) . ' ' . esc_attr($second); ?>" data-wow-delay="<?php echo esc_attr($delay); ?>ms">
                                                <?php if (!empty($item['list_icon_img']['id'])): ?>
                                                    <div class="icon">
                                                        <?php echo wp_get_attachment_image($item['list_icon_img']['id'], 'full'); ?>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="content">
                                                    <?php if (!empty($item['list_title'])): ?><h3><?php echo esc_html($item['list_title']); ?></h3><?php endif; ?>
                                                    <?php if (!empty($item['list_desc'])): ?><p><?php echo esc_html($item['list_desc']); ?></p><?php endif; ?>
                                                </div>
                                            </div>
                                    <?php
                                        }
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Choose_Us());
