<?php

namespace Elementor;

class Choose_Us_V2 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-choose-us-v2';
    }

    public function get_title(): string
    {
        return esc_html__('Choose Us V2', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['choose-us-v2', 'about', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section_av1',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('ABOUT US', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Your Logistics Partner on Every Mile.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'desc',
            [
                'label' => esc_html__('Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('We’re more than a freight carrier—we’re your long-term logistics partner. From the first mile to the final destination, our experienced team ensures every shipment is handled with care, precision, and real-time visibility.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Button Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('VIEW CLASS SCHEDULE', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Button Link', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        //about icons list
        $this->start_controls_section(
            'about_list_section_av1',
            [
                'label' => esc_html__('Icon List', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'icon_separate_image',
            [
                'label' => esc_html__('Separator Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'icon_image',
            [
                'label' => esc_html__('Icon Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'icon_title',
            [
                'label' => esc_html__('Icon Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Full Truckload (FTL)', 'trackngo-core'),
            ]
        );
        $repeater->add_control(
            'icon_desc',
            [
                'label' => esc_html__('Icon Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Ideal for high-volume shipments needing dedicated transport.', 'trackngo-core'),

            ]
        );
        $this->add_control(
            'icon_list',
            [
                'label' => esc_html__('Icon List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ icon_title }}}',
            ]
        );
        $this->end_controls_section();

        //content images
        $this->start_controls_section(
            'images_section_av1',
            [
                'label' => esc_html__('Images', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'about_bg_image',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'title_image',
            [
                'label' => esc_html__('Title Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'about_image',
            [
                'label' => esc_html__('About Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();


        // Trackngo_Elementor_Widget_Init instance
        $trackngo_init = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngo_init->typography_style($this, 'Sub Title', '.section-title h6');

        $trackngo_init->typography_style($this, 'Title', '.section-title h2');

        $trackngo_init->typography_style($this, 'Description', '.choose-text');

        $trackngo_init->typography_style($this, 'Icon Heading', '.icon-heading');

        $trackngo_init->typography_style($this, 'Icon Description', '.icon-desc');

        $trackngo_init->section_style($this, 'Icon Body', '.s.choose-wrapper-3 .choose-content ul li .icon.style-2');

        $trackngo_init->button_style($this, 'Main Button', '.main-button .theme-btn');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $sub_title = $settings['sub_title'];
        $title = $settings['title'];
        $desc = $settings['desc'];
        $btn_title = $settings['btn_title'];
        $btn_link = $settings['btn_link']['url'];

        $title_image = $settings['title_image']['id'];
        $about_image = $settings['about_image']['id'];
        $icon_list = $settings['icon_list'];
?>
        <section class="choose-section-3 section-padding fix bg-cover" style="background-image: url('<?php echo esc_url($settings['about_bg_image']['url']); ?>');">
            <div class="container">
                <div class="choose-wrapper-3">
                    <div class="row g-4">
                        <div class="col-lg-6">
                            <div class="choose-content">
                                <div class="section-title mb-0">
                                    <?php if (!empty($sub_title)): ?><h6 class="wow fadeInUp"><?php echo wp_get_attachment_image($title_image, 'full'); ?><?php echo esc_html($sub_title); ?></h6><?php endif; ?>
                                    <?php if (!empty($title)): ?><h2 class="wow fadeInUp" data-wow-delay=".2s"><?php echo esc_html($title); ?></h2><?php endif; ?>
                                </div>
                                <?php if (!empty($desc)): ?><p class="choose-text wow fadeInUp" data-wow-delay=".3s"><?php echo esc_html($desc); ?> </p><?php endif ?>
                                <ul class="wow fadeInUp" data-wow-delay=".5s">
                                    <?php
                                    if (!empty($icon_list)) {
                                        $delay = 0.4;
                                        foreach ($icon_list as $index => $item) {
                                            $delay += 0.1;
                                            $class = 1 == $index ? 'style-2' : '';
                                    ?>
                                            <li class="wow animated fadeInUp" data-wow-delay=".9s">
                                                <div class="icon <?php echo esc_attr($class); ?>">
                                                    <?php if (!empty($item['icon_image']['id'])): ?>
                                                        <div class="icon">
                                                            <?php echo wp_get_attachment_image($item['icon_image']['id'], 'full'); ?>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="content">
                                                    <?php if (!empty($item['icon_title'])): ?><h4 class="icon-heading"><?php echo esc_html($item['icon_title']); ?></h4><?php endif; ?>
                                                    <?php if (!empty($item['icon_desc'])): ?><p class="icon-desc"><?php echo esc_html($item['icon_desc']); ?></p><?php endif; ?>
                                                </div>
                                            </li>
                                    <?php
                                        }
                                    } ?>
                                </ul>
                                <div class="line-shape">
                                    <?php echo wp_get_attachment_image($settings['icon_separate_image']['id'], 'full'); ?>
                                </div>
                                <?php if (!empty($btn_title)) : ?>
                                    <div class="main-button  wow fadeInUp" data-wow-delay=".9s">
                                        <a href="<?php echo esc_url($btn_link); ?>"> <span class="theme-btn"><?php echo esc_html($btn_title); ?></span><span class="arrow-btn"><i class="fa-regular fa-arrow-up-right"></i></span></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if (!empty($about_image)): ?>
                            <div class="col-lg-6 wow fadeInUp" data-wow-delay=".3s">
                                <div class="choose-image">
                                    <?php echo wp_get_attachment_image($about_image, 'full'); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Choose_Us_V2());
