<?php

namespace Elementor;

class Contact_Card extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-contact-card';
    }

    public function get_title(): string
    {
        return esc_html__('Contact Card', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['contact-card', 'trackngo'];
    }

    protected function register_controls(): void
    {
        //form shortcode
        $this->start_controls_section(
            'form_option',
            [
                'label' => esc_html__('Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Call us,Anytime', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'number',
            [
                'label' => esc_html__('Number', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('+009 (438) 222 9540', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'email',
            [
                'label' => esc_html__('Email', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('admin@inventxlab.com', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => esc_html__('Icon', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-circle',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                    'fa-regular' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Section', '.single-sideber-widget');

        $trackngoElementorInit->typography_style($this, 'Title', '.single-sideber h3');

        $trackngoElementorInit->typography_style($this, 'Contact Info', '.single-sideber h3 a');

        // Icon Style
        $this->start_controls_section(
            'icon_style_section',
            [
                'label' => esc_html__('Icon', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'icon_style_tabs'
        );
        $this->start_controls_tab(
            'icon_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_width',
            [
                'label' => esc_html__('Width', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .single-sideber .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-sideber .icon i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-sideber .icon' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .single-sideber .icon',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'icon_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-sideber .icon:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color_hover',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-sideber .icon:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border_hover',
                'selector' => '{{WRAPPER}} .single-sideber .icon:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="service-details-wrapper">
            <div class="main-sideber">
                    <div class="service-details-contact-bg text-center bg-cover single-sideber" style="background-image: url('<?php echo esc_attr($settings['bg_image']['url']); ?>');">
                        <?php if (!empty($settings['icon']['library'])): ?>
                            <div class="icon">
                                <i class="<?php echo esc_attr($settings['icon']['library'] . ' ' . esc_attr($settings['icon']['value'])); ?>"></i>
                            </div>
                        <?php endif; ?>
                        <?php
                        if (!empty($settings['title'])) {
                            echo '<h3>' . esc_html($settings['title']) . '</h3>';
                        }
                        ?>
                        <?php if (!empty($settings['number'])): ?><h3><a href="tel:<?php echo esc_attr($settings['number']); ?>"><?php echo esc_html($settings['number']); ?></a></h3><?php endif; ?>
                        <?php if (!empty($settings['Email'])): ?><h3><a href="mailto:<?php echo esc_attr($settings['Email']); ?>"><?php echo esc_html($settings['Email']); ?></a></h3><?php endif; ?>
                    </div>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Contact_Card());
