<?php

namespace Elementor;

class Contact_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-contact';
    }

    public function get_title(): string
    {
        return esc_html__('Section Contact V1', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['contact', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section_title',
            [
                'label' => esc_html__('Section', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'sub_title_image_before',
            [
                'label' => esc_html__('Sub Title Before Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('WHY CHOOSE US', 'trackngo-core'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('The Road to Smarter Logistics Starts Here', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'desc',
            [
                'label' => esc_html__('Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('We’re more than a freight carrier—we’re your long-term logistics partner. From the first mile to the final destination, our experienced.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_box_list',
            [
                'label' => esc_html__('Icon Box List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'icon-title',
                        'label' => esc_html__('Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Customer Satisfaction', 'trackngo-core'),
                    ],
                    [
                        'name' => 'icon_image',
                        'label' => esc_html__('Icon Image', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                ],
                'title_field' => '{{{ icon_image.title }}}',
            ]
        );

        $this->add_control(
            'btn_text',
            [
                'label' => esc_html__('Button Text', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('READ MORE', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'button_link',
            [
                'label' => esc_html__('Button Link', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        //form shortcode
        $this->start_controls_section(
            'form_option',
            [
                'label' => esc_html__('Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'form_title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Form Title', 'trackngo-core'),
                'default' => esc_html__('Request For a Free Quote', 'trackngo-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'form_shortcode',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Shortcode', 'trackngo-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'form_bg_image',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'form_arrow_image',
            [
                'label' => esc_html__('Arrow Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Section', '.contact-section');

        $trackngoElementorInit->typography_style($this, 'Sub Title', '.IXL-sub-title');

        $trackngoElementorInit->typography_style($this, 'Title', '.IXL-title');

        $trackngoElementorInit->typography_style($this, 'Description', '.IXL-desc');

        $trackngoElementorInit->typography_style($this, 'Icon Title', '.icon-box h4');

        $trackngoElementorInit->button_style($this, 'Button', '.main-button .theme-btn');

        $trackngoElementorInit->typography_style($this, 'From Title', '.form-title');

        $trackngoElementorInit->button_style($this, 'Form Button', '.contact-form-items .main-button .theme-btn');

        $trackngoElementorInit->section_style($this, 'Form Body', '.contact-box-items');

        //form style controls
        $this->start_controls_section(
            'form_style_option',
            [
                'label' => esc_html__('Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'field_typography',
                'selector' => '{{WRAPPER}} .form-clt input, {{WRAPPER}} .form-clt textarea, {{WRAPPER}} .form-clt select ',
            ]
        );
        $this->add_control(
            'form_bg_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .form-clt input::placeholder' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .form-clt textarea::placeholder' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .form-clt select::placeholder' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_bg-c',
            [
                'label' => esc_html__('Background Color', 'trackngo-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .form-clt input' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .form-clt textarea' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .form-clt select' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_box_shadow',
                'selector' => '{{WRAPPER}} .form-clt input, {{WRAPPER}} .form-clt textarea, {{WRAPPER}} .form-clt select',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_border',
                'selector' => '{{WRAPPER}} .form-clt input, {{WRAPPER}} .form-clt textarea, {{WRAPPER}} .form-clt select ',
            ]
        );
        $this->end_controls_section();
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $icon_box_list = !empty($settings['icon_box_list']) ? $settings['icon_box_list'] : [];
?>
        <section class="contact-section section-padding pb-0 fix bg-cover" style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>');">
            <div class="container">
                <div class="contact-wrapper">
                    <div class="row g-4">
                        <div class="col-lg-6">
                            <div class="contact-content">
                                <div class="section-title mb-0">
                                    <?php if (!empty($settings['sub_title'])): ?><h6 class="IXL-sub-title wow fadeInUp"><?php echo wp_get_attachment_image($settings['sub_title_image_before']['id'], 'full'); ?><?php echo esc_html($settings['sub_title']); ?></h6><?php endif; ?>
                                    <?php if (!empty($settings['title'])): ?><h2 class="IXL-title text-white wow fadeInUp" data-wow-delay=".2s"> <?php echo esc_html($settings['title']); ?></h2><?php endif; ?>
                                </div>
                                <?php if (!empty($settings['desc'])): ?><p class="IXL-desc contact-text wow fadeInUp" data-wow-delay=".4s"><?php echo esc_html($settings['desc']); ?></p><?php endif ?>
                                <div class="icon-box-area">
                                    <?php
                                    if (!empty($icon_box_list)):
                                        foreach ($icon_box_list as $index => $item) : ?>
                                            <div class="icon-box wow fadeInUp" data-wow-delay="<?php echo esc_attr(0.6 + ($index * 0.2)); ?>s">
                                                <?php if (!empty($item['icon_image']['id'])): ?>
                                                    <div class="icon">
                                                        <?php echo wp_get_attachment_image($item['icon_image']['id'], 'full'); ?>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if (!empty($item['icon-title'])): ?><h4><?php echo esc_html($item['icon-title']); ?></h4><?php endif; ?>
                                            </div>
                                    <?php
                                        endforeach;
                                    endif;
                                    ?>
                                </div>
                                <?php if ($settings['btn_text']):; ?>
                                    <div class="main-button wow fadeInUp" data-wow-delay=".9s">
                                        <a href="<?php echo esc_attr($settings['button_link']['url']); ?>"> <span class="theme-btn"><?php echo esc_html($settings['btn_text']); ?> </span><span class="arrow-btn"><i class="fa-regular fa-arrow-up-right"></i></span></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if ($settings['form_shortcode']): ?>
                            <div class="col-lg-6">
                                <div class="contact-box-items bg-cover" style="background-image: url('<?php echo esc_url($settings['form_bg_image']['url']); ?>');">
                                    <?php if (!empty($settings['form_arrow_image']['id'])): ?>
                                        <div class="arrow-image">
                                            <?php echo wp_get_attachment_image($settings['form_arrow_image']['id'], 'full'); ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['form_title'])): ?><h3 class="form-title"><?php echo esc_html($settings['form_title']); ?></h3><?php endif; ?>
                                    <?php if (!empty($settings['form_shortcode'])): ?>
                                        <div class="contact-form-items">
                                            <?php echo do_shortcode($settings['form_shortcode']); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>

<?php
    }
}
Plugin::instance()->widgets_manager->register(new Contact_V1());
