<?php

namespace Elementor;

class Contact_V2 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-contact-v2';
    }

    public function get_title(): string
    {
        return esc_html__('Section Contact V2', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['contact-v2', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section_title',
            [
                'label' => esc_html__('Section', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'sub_title_image_before',
            [
                'label' => esc_html__('Sub Title Before Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('WHY CHOOSE US', 'trackngo-core'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('The Road to Smarter Logistics Starts Here', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'desc',
            [
                'label' => esc_html__('Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('We’re more than a freight carrier—we’re your long-term logistics partner. From the first mile to the final destination, our experienced.', 'trackngo-core'),
            ]
        );
        $this->end_controls_section();

        //form shortcode
        $this->start_controls_section(
            'form_option',
            [
                'label' => esc_html__('Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'form_title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Form Title', 'trackngo-core'),
                'default' => esc_html__('Request For a Free Quote', 'trackngo-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'form_shortcode',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Form Shortcode', 'trackngo-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'form_bg_image',
            [
                'label' => esc_html__('Form Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'form_arrow_image',
            [
                'label' => esc_html__('Arrow Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();


        //contact info
        $this->start_controls_section(
            'contact_option',
            [
                'label' => esc_html__('Contact', 'aivora-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            '_contact_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Opening Hour', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'contact_icon_box_list',
            [
                'label' => esc_html__('Contact List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'contact_icon_title',
                        'label' => esc_html__('Contact Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Looking For Consultation', 'trackngo-core'),
                    ],
                    [
                        'name'  => 'number_email',
                        'label' => esc_html__('Border Style', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => 'number',
                        'options' => [
                            'number' => esc_html__('Number', 'trackngo-core'),
                            'email' => esc_html__('Email', 'trackngo-core'),
                            'others' => esc_html__('Others', 'trackngo-core'),
                        ],
                    ],
                    [
                        'name' => 'contact_number',
                        'label' => esc_html__('Contact Number', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('+00 (47) 939 4888', 'trackngo-core'),
                        'condition' => [
                            'number_email' => 'number',
                        ]
                    ],
                    [
                        'name' => 'contact_email',
                        'label' => esc_html__('Contact Email', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('admin@inventxlab.com', 'trackngo-core'),
                        'condition' => [
                            'number_email' => 'email',
                        ]
                    ],
                    [
                        'name' => 'contact_others',
                        'label' => esc_html__('Information', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('25 Street, New York, USA', 'trackngo-core'),
                        'condition' => [
                            'number_email' => 'others',
                        ]
                    ],
                    [
                        'name' => 'contact_icon',
                        'label' => esc_html__('Icon', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                    ]
                ],
                'title_field' => '{{{ contact_number.title }}}',
            ]
        );
        $this->end_controls_section();

        //open hour
        $this->start_controls_section(
            'open_hour_option',
            [
                'label' => esc_html__('Open Hours', 'aivora-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'open_hour_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Opening Hour', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'hours_list',
            [
                'label' => esc_html__('Hours List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'hours_title',
                        'label' => esc_html__('Hours Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Friday', 'trackngo-core'),
                    ],
                    [
                        'name' => 'hours',
                        'label' => esc_html__('Time', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('9am - 10pm', 'trackngo-core'),
                    ],
                ],
                'title_field' => '{{{ hours_title }}}',
            ]
        );
        $this->end_controls_section();


        //icon_box info
        $this->start_controls_section(
            'icon_box_option',
            [
                'label' => esc_html__('Icon Box', 'aivora-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'icon_box_list',
            [
                'label' => esc_html__('Icon List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => '_icon_title',
                        'label' => esc_html__('Contact Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('REQUEST A QUOTE', 'trackngo-core'),
                    ],
                    [
                        'name' => 'icon_image',
                        'label' => esc_html__('Choose Image', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ]

                ],
                'title_field' => '{{{ _icon_title }}}',
            ]
        );
        $this->end_controls_section();



        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Section', '.contact-section-3');

        $trackngoElementorInit->typography_style($this, 'Sub Title', '.IXL-sub-title');

        $trackngoElementorInit->typography_style($this, 'Title', '.IXL-title');

        $trackngoElementorInit->typography_style($this, 'Description', '.IXL-desc');

        // $trackngoElementorInit->typography_style($this, 'Icon Title', '.icon-box h4');

        // $trackngoElementorInit->button_style($this, 'Button', '.main-button .theme-btn');

        $trackngoElementorInit->typography_style($this, 'Contact Title', '.left-items h4');

        $trackngoElementorInit->typography_style($this, 'Contact Info Title', '.content p');

        $trackngoElementorInit->typography_style($this, 'Contact Info', '.content h5 a');

        $trackngoElementorInit->section_style($this, 'Open Hour Body', '.open-hour');

        $trackngoElementorInit->typography_style($this, 'Open Hour', '.open-hour h4');

        $trackngoElementorInit->typography_style($this, 'Open Hour Title', '.open-hour li p');

        $trackngoElementorInit->typography_style($this, 'Open Hour Info', '.open-hour li h5');

        $trackngoElementorInit->typography_style($this, 'Icon Title', '.feature-items h4');

        $trackngoElementorInit->section_style($this, 'Icon Body', '.feature-items');

        $trackngoElementorInit->section_style($this, 'Icon Body Hover', '.feature-items:hover');

        $trackngoElementorInit->button_style($this, 'Form Button', '.contact-form-items .main-button .theme-btn');

        //form style controls
        $this->start_controls_section(
            'form_style_option',
            [
                'label' => esc_html__('Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'field_typography',
                'selector' => '{{WRAPPER}} .form-clt input, {{WRAPPER}} .form-clt textarea, {{WRAPPER}} .form-clt select ',
            ]
        );
        $this->add_control(
            'form_bg_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .form-clt input::placeholder' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .form-clt textarea::placeholder' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .form-clt select::placeholder' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_bg-c',
            [
                'label' => esc_html__('Background Color', 'trackngo-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .form-clt input' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .form-clt textarea' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .form-clt select' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_box_shadow',
                'selector' => '{{WRAPPER}} .form-clt input, {{WRAPPER}} .form-clt textarea, {{WRAPPER}} .form-clt select',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_border',
                'selector' => '{{WRAPPER}} .form-clt input, {{WRAPPER}} .form-clt textarea, {{WRAPPER}} .form-clt select ',
            ]
        );
        $this->end_controls_section();
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $icon_box_list = !empty($settings['icon_box_list']) ? $settings['icon_box_list'] : [];
?>
        <section class="contact-section-3 section-padding fix bg-cover" style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>');">
            <div class="container">
                <div class="contact-wrapper-3">
                    <div class="row g-0">
                        <div class="col-xl-6">
                            <div class="contact-box-items bg-cover" style="background-image: url('<?php echo esc_url($settings['form_bg_image']['url']); ?>');">
                                <?php if (!empty($settings['form_arrow_image']['id'])): ?>
                                    <div class="line-image">
                                        <?php echo wp_get_attachment_image($settings['form_arrow_image']['id'], 'full'); ?>
                                    </div>
                                <?php endif; ?>
                                <?php if (!empty($settings['form_title'])): ?><h3 class="form-title"><?php echo esc_html($settings['form_title']); ?></h3><?php endif; ?>
                                <?php if (!empty($settings['form_shortcode'])): ?>
                                    <div class="contact-form-items">
                                        <?php echo do_shortcode($settings['form_shortcode']); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="contact-content">
                                <div class="contact-right-item-3">
                                    <div class="section-title mb-0">
                                        <?php if (!empty($settings['sub_title'])): ?><h6 class="IXL-sub-title wow fadeInUp"><?php echo wp_get_attachment_image($settings['sub_title_image_before']['id'], 'full'); ?><?php echo esc_html($settings['sub_title']); ?></h6><?php endif; ?>
                                        <?php if (!empty($settings['title'])): ?><h2 class="IXL-title wow fadeInUp" data-wow-delay=".2s"> <?php echo esc_html($settings['title']); ?></h2><?php endif; ?>
                                    </div>
                                    <?php if (!empty($settings['desc'])): ?><p class="IXL-desc contact-text wow fadeInUp" data-wow-delay=".4s"><?php echo esc_html($settings['desc']); ?></p><?php endif ?>
                                    <div class="middle-items">
                                        <div class="row">
                                            <div class="col-lg-6 wow fadeInUp" data-wow-delay=".5s">
                                                <div class="left-items">
                                                    <?php if (!empty($settings['_contact_title'])): ?><h4><?php echo esc_html($settings['_contact_title']); ?></h4><?php endif; ?>
                                                    <ul>
                                                        <?php
                                                        if (!empty($settings['contact_icon_box_list'])) {
                                                            foreach ($settings['contact_icon_box_list'] as $item) {
                                                        ?>
                                                                <li>
                                                                    <?php if (!empty(esc_attr($item['contact_icon']['library']))): ?>
                                                                        <div class="icon">
                                                                            <i class="<?php echo esc_attr($item['contact_icon']['library']) . ' ' . esc_attr($item['contact_icon']['value']); ?>"></i>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                    <div class="content">
                                                                        <?php if (!empty($item['contact_icon_title'])): ?><p><?php echo esc_html($item['contact_icon_title']); ?></p><?php endif; ?>
                                                                        <?php
                                                                        if ('number' == $item['number_email']) {
                                                                            echo '<h5><a href="tel:' . esc_attr($item['contact_number']) . '">' . esc_html($item['contact_number']) . '</a></h5>';
                                                                        } elseif ('email' == $item['number_email']) {
                                                                            echo '<h5><a href="mailto:' . esc_attr($item['contact_email']) . '">' . esc_html($item['contact_email']) . '</a></h5>';
                                                                        } else {
                                                                            echo '<h5>' . esc_html($item['contact_others']) . '</h5>';
                                                                        }
                                                                        ?>
                                                                    </div>
                                                                </li>
                                                        <?php
                                                            };
                                                        }; ?>
                                                    </ul>
                                                </div>
                                            </div>
                                            <?php if (!empty($settings['hours_list'])): ?>
                                                <div class="col-lg-6 wow fadeInUp" data-wow-delay=".7s">
                                                    <div class="right-items open-hour">
                                                        <?php if (!empty($settings['open_hour_title'])): ?><h4><?php echo esc_html($settings['open_hour_title']); ?></h4><?php endif; ?>
                                                        <ul>
                                                            <?php foreach ($settings['hours_list'] as $list) { ?>
                                                                <li>
                                                                    <?php if (!empty($list['hours_title'])): ?><p><?php echo esc_html($list['hours_title']); ?></p><?php endif; ?>
                                                                    <?php if (!empty($list['hours'])): ?><h5><?php echo esc_html($list['hours']); ?></h5><?php endif; ?>
                                                                </li>
                                                            <?php } ?>
                                                        </ul>
                                                    </div>
                                                </div>
                                            <?php endif ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="feature-box-items-3">
                                    <div class="row g-0">
                                        <?php if (!empty($settings['icon_box_list'])):
                                            foreach ($settings['icon_box_list'] as $item):
                                        ?>
                                                <div class="col-lg-4 col-md-6">
                                                    <div class="feature-items">
                                                        <?php if (!empty($item['icon_image']['id'])): ?>
                                                            <div class="icon">
                                                                <?php echo wp_get_attachment_image($item['icon_image']['id'], 'full'); ?>
                                                            </div>
                                                        <?php endif; ?>
                                                        <?php if (!empty($item['_icon_title'])): ?><h4><?php echo esc_html($item['_icon_title']); ?></h4><?php endif; ?>
                                                    </div>
                                                </div>
                                        <?php
                                            endforeach;
                                        endif;
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

<?php
    }
}
Plugin::instance()->widgets_manager->register(new Contact_V2());
