<?php

namespace Elementor;

class Contact_V3 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-contact-v3';
    }

    public function get_title(): string
    {
        return esc_html__('Contact V3', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['contact-v3', 'trackngo'];
    }

    protected function register_controls(): void
    {
        //form shortcode
        $this->start_controls_section(
            'form_option',
            [
                'label' => esc_html__('Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'form_title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Form Title', 'trackngo-core'),
                'default' => esc_html__('Contact With Us', 'trackngo-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'form_shortcode',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Shortcode', 'trackngo-core'),
                'default' => '[contact-form-7 id="6427517" title="Service Details Form"]',
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Section', '.single-sideber-widget');

        $trackngoElementorInit->typography_style($this, 'Title', '.single-sideber-widget .widget-title h3');

        $trackngoElementorInit->button_style($this, 'Form Button', '.contact-form-items .wpcf7-form button');


        //form style controls
        $this->start_controls_section(
            'form_style_option',
            [
                'label' => esc_html__('Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'field_typography',
                'selector' => '{{WRAPPER}} .wpcf7-form .form-clt input, {{WRAPPER}} .wpcf7-form .form-clt textarea, {{WRAPPER}} .wpcf7-form .form-clt select ',
            ]
        );
        $this->add_control(
            'form_bg_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form .form-clt input::placeholder' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .wpcf7-form .form-clt textarea::placeholder' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .wpcf7-form .form-clt select::placeholder' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_bg-c',
            [
                'label' => esc_html__('Background Color', 'trackngo-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form .form-clt input' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .wpcf7-form .form-clt textarea' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .wpcf7-form .form-clt select' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_box_shadow',
                'selector' => '{{WRAPPER}} .wpcf7-form .form-clt input, {{WRAPPER}} .wpcf7-form .form-clt textarea, {{WRAPPER}} .wpcf7-form .form-clt select',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_border',
                'selector' => '{{WRAPPER}} .wpcf7-form .form-clt input, {{WRAPPER}} .wpcf7-form .form-clt textarea, {{WRAPPER}} .wpcf7-form .form-clt select ',
            ]
        );
        $this->end_controls_section();
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="service-details-wrapper">
            <div class="main-sideber">
                <div class="single-sideber-widget">
                    <div class="single-sideber-widget">
                        <?php if (!empty($settings['form_title'])): ?>
                            <div class="widget-title">
                                <h3><?php echo esc_html($settings['form_title']); ?></h3>
                            </div>
                        <?php endif; ?>
                        <div class="search-widget">
                            <?php if (!empty($settings['form_shortcode'])): ?>
                                <div class="contact-form-items">
                                    <?php echo do_shortcode($settings['form_shortcode']); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>


<?php
    }
}
Plugin::instance()->widgets_manager->register(new Contact_V3());
