<?php

namespace Elementor;

class Section_Counter extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-section-counter';
    }

    public function get_title(): string
    {
        return esc_html__('Section Counter V1', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['section-counter', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'counter_content_section',
            [
                'label' => esc_html__('Counter', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'counter_list',
            [
                'label' => esc_html__('Counter List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'counter_number',
                        'label' => esc_html__('Number', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('480', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'counter_number_suffix',
                        'label' => esc_html__('Counter Suffix', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('K', 'trackngo-core'),
                        'show_label' => false,
                    ],
                    [
                        'name' => 'counter_title',
                        'label' => esc_html__('Counter Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Deliveries Completed', 'trackngo-core'),
                        'show_label' => false,
                    ],
                ],
                'title_field' => '{{{ counter_number }}} {{{ counter_number_suffix }}}',
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'images_content_section',
            [
                'label' => esc_html__('Images', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'images_list',
            [
                'label' => esc_html__('Images List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'image',
                        'label' => esc_html__('Choose Image', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ]
                ],
                'title_field' => '{{{ image.title }}}',
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();
        $trackngoElementorInit->section_style($this, 'Section', '.counter-section');
        $trackngoElementorInit->section_style($this, 'Counter Item', '.counter-item');
        $trackngoElementorInit->typography_style($this, 'Number', '.counter-item h1 span');
        $trackngoElementorInit->typography_style($this, 'Suffix', '.counter-item h1 span');
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $counter_list = isset($settings['counter_list']) ? $settings['counter_list'] : [];
        $images_list = isset($settings['images_list']) ? $settings['images_list'] : [];
?>
        <section class="counter-section section-padding fix bg-cover pt-0"
            style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>');">
            <div class="container">
                <div class="row g-0">
                    <?php
                    if (!empty($counter_list)) {
                        foreach ($counter_list as $counter) { ?>

                            <div class="col-xl-3 col-lg-4 col-md-6">
                                <div class="counter-item wow fadeInUp">
                                    <?php if (!empty($counter['counter_number'])): ?><h2><span class="count"><?php echo esc_html($counter['counter_number']); ?></span><?php echo esc_html($counter['counter_number_suffix']); ?></h2><?php endif; ?>
                                    <?php if (!empty($counter['counter_title'])): ?><p><?php echo esc_html($counter['counter_title']); ?></p><?php endif; ?>
                                </div>
                            </div>
                    <?php
                        }
                    }
                    ?>
                </div>
            </div>
            <div class="brand-section section-padding pb-0">
                <div class="swiper brand-slide">
                    <div class="swiper-wrapper">
                        <?php
                        if (!empty($images_list)) {
                            foreach ($images_list as $image) { ?>
                                <div class="swiper-slide">
                                    <div class="brand-image text-center">
                                        <?php echo wp_get_attachment_image($image['image']['id'], 'full'); ?>
                                    </div>
                                </div>
                        <?php
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Section_Counter());
