<?php

namespace Elementor;

class Section_Counter_V2 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-section-counter-v2';
    }

    public function get_title(): string
    {
        return esc_html__('Section Counter V2', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['section-counter', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section_counter',
            [
                'label' => esc_html__('Counter', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'counter_list',
            [
                'label' => esc_html__('Counter List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'counter_number',
                        'label' => esc_html__('Number', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('480', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'counter_suffix',
                        'label' => esc_html__('Suffix Text', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('K', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'counter_description',
                        'label' => esc_html__('Counter Description', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Deliveries Completed', 'trackngo-core'),
                        'label_block' => true,
                    ],
                ],
                'title_field' => '{{{ counter_number }}}',
            ]
        );
        $this->end_controls_section();

        //video and section content placeholder
        $this->start_controls_section(
            'content_section_',
            [
                'label' => esc_html__('Section & Video', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Choose Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'video_btn_title',
            [
                'label' => esc_html__('Video Buttion Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Let’s Take Video', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'video_link',
            [
                'label' => esc_html__('Video Link', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Section ', '.counter-section-2');

        $trackngoElementorInit->typography_style($this, 'Number', '.counter-items h2 span');

        $trackngoElementorInit->typography_style($this, 'Suffix', '.counter-items h2');

        $trackngoElementorInit->typography_style($this, 'Description', '.counter-items p');

        $trackngoElementorInit->section_style($this, 'Counter Item ', '.counter-items');


        $trackngoElementorInit->typography_style($this, 'Video Text', '.video-items h3');

        $trackngoElementorInit->button_style($this, 'Play icon', '.video-items .video-btn');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $counter_list = isset($settings['counter_list']) ? $settings['counter_list'] : [];
?>
        <section class="counter-section-2 section-padding bg-cover" style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>');">
            <div class="container">
                <div class="counter-box">
                    <div class="row g-4">
                        <?php
                        if (!empty($counter_list)) :
                            foreach ($counter_list as $index => $item) :
                                $style = $index % 2 === 1 ? '' : 'style-2';
                        ?>
                                <div class="col-lg-3">
                                    <div class="counter-items wow fadeInUp <?php echo esc_attr($style); ?>" data-wow-delay="<?php echo esc_attr($index * 0.2); ?>s">
                                        <?php if (!empty($item['counter_number'])): ?><h2><span class="count"><?php echo esc_html($item['counter_number']); ?></span><?php echo esc_html($item['counter_suffix']); ?></h2><?php endif; ?>
                                        <?php if (!empty($item['counter_description'])): ?><p><?php echo esc_html($item['counter_description']); ?></p><?php endif; ?>
                                    </div>
                                </div>
                        <?php
                            endforeach;
                        endif;
                        ?>
                    </div>
                </div>
                <div class="video-items wow fadeInUp" data-wow-delay=".3s">
                    <?php if (!empty($settings['video_link']['url'])): ?><a href="<?php echo esc_url($settings['video_link']['url']); ?>" class="video-btn ripple video-popup"> <i class="fas fa-play"></i></a><?php endif; ?>
                    <?php if (!empty($settings['video_btn_title'])): ?><h3><?php echo esc_html($settings['video_btn_title']); ?></h3><?php endif; ?>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Section_Counter_V2());
