<?php

namespace Elementor;

class Section_Counter_V3 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-section-counter-v3';
    }

    public function get_title(): string
    {
        return esc_html__('Section Counter V3', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['section-counter', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section_counter',
            [
                'label' => esc_html__('Counter', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'counter_list',
            [
                'label' => esc_html__('Counter List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'counter_number',
                        'label' => esc_html__('Number', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('480', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'counter_suffix',
                        'label' => esc_html__('Suffix Text', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('K', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'counter_description',
                        'label' => esc_html__('Counter Description', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Deliveries Completed', 'trackngo-core'),
                        'label_block' => true,
                    ],
                ],
                'title_field' => '{{{ counter_number }}}',
            ]
        );
        $this->end_controls_section();

        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Section ', '.counter-section-3');

        $trackngoElementorInit->typography_style($this, 'Number', '.counter-item-3 h2 span');

        $trackngoElementorInit->typography_style($this, 'Suffix', '.counter-item-3 h2');

        $trackngoElementorInit->typography_style($this, 'Description', '.counter-item-3 p');

        $trackngoElementorInit->section_style($this, 'Counter Item ', '.counter-item-3');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $counter_list = isset($settings['counter_list']) ? $settings['counter_list'] : [];
?>
        <section class="counter-section-3 section-padding pt-0">
            <div class="container">
                <div class="row g-0">
                    <?php
                    if (!empty($counter_list)) :
                        foreach ($counter_list as $item) :
                    ?>
                            <div class="col-lg-3">
                                <div class="counter-item-3 wow fadeInUp">
                                    <?php if (!empty($item['counter_number'])): ?><h2><span class="count"><?php echo esc_html($item['counter_number']); ?></span><?php echo esc_html($item['counter_suffix']); ?></h2><?php endif; ?>
                                    <?php if (!empty($item['counter_description'])): ?><p><?php echo esc_html($item['counter_description']); ?></p><?php endif; ?>
                                </div>
                            </div>
                    <?php
                        endforeach;
                    endif;
                    ?>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Section_Counter_V3());
