<?php

namespace Elementor;

class Feature_Item_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-feature-item-v1';
    }

    public function get_title(): string
    {
        return esc_html__('Featur Item V1', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['feature-item', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'feature_icon',
            [
                'label' => esc_html__('Icon', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'feature_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'rows' => 10,
                'default' => esc_html__('Land Freight Services', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'feature_content',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => esc_html__('Efficient cargo transfer between major international hubs.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'animation_delay',
            [
                'label' => esc_html__('Animation Delay (MS)', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'rows' => 10,
                'default' => esc_html__('400', 'trackngo-core'),
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();
        $trackngoElementorInit->section_style($this, 'Feature Item ', '.feature-box-items');
        $trackngoElementorInit->section_style($this, 'Feature Item Hover', '.feature-box-items:hover');
        $trackngoElementorInit->typography_style($this, 'Title', '.feature-icon-box h3');
        $trackngoElementorInit->typography_style($this, 'Description', '.feature-box-items p');
        $trackngoElementorInit->section_style($this, 'Icon Body', '.icon');
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="feature-box-items wow animated fadeInUp" data-wow-delay="<?php echo esc_attr($settings['animation_delay']); ?>ms">
            <div class="feature-icon-box">
                <?php if (!empty($settings['feature_icon']['id'])): ?>
                    <div class="icon">
                        <?php echo wp_get_attachment_image($settings['feature_icon']['id'], 'full'); ?>
                    </div>
                <?php endif; ?>
                <?php if (!empty($settings['feature_title'])): ?><h3><?php echo esc_html($settings['feature_title']); ?></h3><?php endif; ?>
            </div>
            <?php if (!empty($settings['feature_content'])): ?><p><?php echo esc_html($settings['feature_content']); ?></p><?php endif; ?>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Feature_Item_V1());
