<?php

namespace Elementor;

class Footer_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-footer-v1';
    }

    public function get_title(): string
    {
        return esc_html__('Footer V1', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_hf_widgets'];
    }

    public function get_keywords(): array
    {
        return ['footer-v1', 'footer', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'newsletter_content_section',
            [
                'label' => esc_html__('Newsletter', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_img',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'form_logo',
            [
                'label' => esc_html__('Logo Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'form_title',
            [
                'label' => esc_html__('Form Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Subscribe Newsletter', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'form_shortcode',
            [
                'label' => esc_html__('Form Shortcode', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('[contact-form-7 id="41396fb" title="Newsletter One"]', 'trackngo-core'),
            ]
        );
        $this->end_controls_section();

        //contact
        $this->start_controls_section(
            'contact_content_section',
            [
                'label' => esc_html__('Contact', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'contact_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Get in Touch', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'location_title',
            [
                'label' => esc_html__('Location Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Corporate Office', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'location_desc',
            [
                'label' => esc_html__('Location Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('3891 Ranchview Dr. Richardson, California 62639', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'phone_number_label',
            [
                'label' => esc_html__('Phone Number Label', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Call Us:', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'phone_number',
            [
                'label' => esc_html__('Phone Number', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('+1-416-8241228', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'email_address_label',
            [
                'label' => esc_html__('Email Address Label', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Email:', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'email_address',
            [
                'label' => esc_html__('Email Address', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('infotrackgo@email.com', 'trackngo-core'),
            ]
        );
        $this->end_controls_section();

        //menu one
        $this->start_controls_section(
            'menu_one_content_section',
            [
                'label' => esc_html__('Menu One', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'menu_one_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Service', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'menu_list_1',
            [
                'label' => esc_html__('Menu List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'menu_title',
                        'label' => esc_html__('Menu Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Freight Transportation', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'menu_link',
                        'label' => esc_html__('Link', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ menu_title }}}',
            ]
        );
        $this->end_controls_section();

        //menu two
        $this->start_controls_section(
            'menu_two_content_section',
            [
                'label' => esc_html__('Menu Two', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'menu_two_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Service', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'menu_list_2',
            [
                'label' => esc_html__('Menu List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'menu_title_two',
                        'label' => esc_html__('Menu Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Freight Transportation', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'menu_link_two',
                        'label' => esc_html__('Link', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ menu_title_two }}}',
            ]
        );
        $this->end_controls_section();


        //ciopyright area
        $this->start_controls_section(
            'copyright_content_section',
            [
                'label' => esc_html__('Copyright', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'copyright_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Service', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'copyright_icon_list',
            [
                'label' => esc_html__('Icon List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'icon_item',
                        'label' => esc_html__('Icon', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                    ],
                    [
                        'name' => 'link_item',
                        'label' => esc_html__('Link', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ icon_item.title }}}',
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Section', '.footer-section');

        $trackngoElementorInit->typography_style($this, 'Newsletter Title', '.footer-top-items h3');

        $trackngoElementorInit->button_style($this, 'Form Button', '.footer-top-items .ixl-footer-newsletter button');

        //form style controls
        $this->start_controls_section(
            'form_style_option',
            [
                'label' => esc_html__('Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'field_typography',
                'selector' => '{{WRAPPER}} .footer-top-items .ixl-footer-newsletter input',
            ]
        );
        $this->add_control(
            'form_bg_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-top-items .ixl-footer-newsletter input' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_bg-c',
            [
                'label' => esc_html__('Background Color', 'trackngo-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-top-items .ixl-footer-newsletter input' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_box_shadow',
                'selector' => '{{WRAPPER}} .footer-top-items .ixl-footer-newsletter input',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_border',
                'selector' => '{{WRAPPER}} .footer-top-items .ixl-footer-newsletter input',
            ]
        );
        $this->end_controls_section();


        $trackngoElementorInit->typography_style($this, 'Contact Title & Menu Title', '.widget-head h3');

        $trackngoElementorInit->typography_style($this, 'Location Title', '.content h6');

        $trackngoElementorInit->typography_style($this, 'Location Description', '.content span');

        $trackngoElementorInit->typography_style($this, 'Phone Number & Email', '.footer-number-and-email');

        $trackngoElementorInit->typography_style($this, 'Menu Item', '.list-area li a');

        $trackngoElementorInit->section_style($this, 'Copyright Section', '.footer-bottom');

        $trackngoElementorInit->typography_style($this, 'Copyright Text', '.copyright-text');


        // Social Icon Style
        $this->start_controls_section(
            'icon_style_section',
            [
                'label' => esc_html__('Social Icon', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'icon_style_tabs'
        );
        $this->start_controls_tab(
            'icon_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_width',
            [
                'label' => esc_html__('Width', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .social-icon a i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .social-icon a',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'icon_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color_hover',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border_hover',
                'selector' => '{{WRAPPER}} .social-icon a:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $form_shortcode = $settings['form_shortcode'] ?? '';
        $menu_list_1 = $settings['menu_list_1'] ?? [];
        $menu_list_2 = $settings['menu_list_2'] ?? [];
        $copyright_icon_list = $settings['copyright_icon_list'] ?? [];
?>
        <footer class="footer-section fix bg-cover" style="background-image:url('<?php echo esc_url($settings['bg_img']['url']); ?>');">
            <div class="container">
                <div class="footer-top-items">
                    <?php if (!empty(wp_get_attachment_image($settings['form_logo']['id']))): ?>
                        <div class="footer-logo">
                            <a href="<?php echo esc_url(home_url('/')); ?>">
                                <?php echo wp_get_attachment_image($settings['form_logo']['id'], 'full'); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($settings['form_title'])): ?><h3><?php echo esc_html($settings['form_title']); ?></h3><?php endif; ?>

                    <?php if (!empty($form_shortcode)): ?>
                        <div class="ixl-footer-newsletter">
                            <?php echo do_shortcode($form_shortcode); ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="footer-widget-wrapper">
                    <div class="row justify-content-between">
                        <div class="col-lg-6">
                            <div class="single-footer-widget single-border wow fadeInUp" data-wow-delay=".3s">
                                <?php if (!empty($settings['contact_title'])): ?>
                                    <div class="widget-head">
                                        <h3><?php echo esc_html($settings['contact_title']); ?></h3>
                                    </div>
                                <?php endif; ?>
                                <ul class="footer-contact cont">
                                    <li>
                                        <div class="icon-location">
                                            <i class="fa-solid fa-location-dot"></i>
                                            <div class="content">
                                                <?php if (!empty($settings['location_title'])): ?><h6><?php echo esc_html($settings['location_title']); ?></h6><?php endif; ?>
                                                <?php if (!empty($settings['location_desc'])): ?><span><?php echo esc_html($settings['location_desc']); ?></span><?php endif; ?>
                                            </div>
                                        </div>
                                    </li>
                                    <?php if (!empty($settings['phone_number'])): ?><li class="mb-2"> <a href="tel:<?php echo esc_attr($settings['phone_number']); ?>" class="footer-number-and-email"><?php echo esc_html($settings['phone_number_label']); ?> <?php echo esc_html($settings['phone_number']); ?></a></li><?php endif; ?>
                                    <?php if (!empty($settings['email_address'])): ?><li><a href="mailto:<?php echo esc_attr($settings['email_address']); ?>" class="footer-number-and-email"><?php echo esc_html($settings['email_address_label']); ?> <?php echo esc_html($settings['email_address']); ?></a></li><?php endif; ?>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="single-footer-widget wow fadeInUp" data-wow-delay=".5s">
                                <div class="widget-head">
                                    <?php if (!empty($settings['menu_one_title'])): ?><h3><?php echo esc_html($settings['menu_one_title']); ?></h3><?php endif; ?>
                                </div>
                                <ul class="list-area">
                                    <?php
                                    if (!empty($menu_list_1)) {
                                        foreach ($menu_list_1 as $item) {
                                            $menu_title = $item['menu_title'] ?? '';
                                            $menu_link = $item['menu_link']['url'] ?? '#';
                                            echo '<li><a href="' . esc_url($menu_link) . '">' . esc_html($menu_title) . '</a></li>';
                                        }
                                    }
                                    ?>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-2">
                            <div class="single-footer-widget wow fadeInUp" data-wow-delay=".7s">
                                <?php if (!empty($settings['menu_two_title'])): ?>
                                    <div class="widget-head">
                                        <h3><?php echo esc_html($settings['menu_two_title']); ?></h3>
                                    </div>
                                <?php endif; ?>
                                <ul class="list-area">
                                    <?php
                                    if (!empty($menu_list_2)) {
                                        foreach ($menu_list_2 as $item) {
                                            $menu_title_two = $item['menu_title_two'] ?? '';
                                            $menu_link_two = $item['menu_link_two']['url'] ?? '#';
                                            echo '<li><a href="' . esc_url($menu_link_two) . '">' . esc_html($menu_title_two) . '</a></li>';
                                        }
                                    }
                                    ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <div class="container">
                    <div class="footer-bottom-wrapper">
                        <?php if (!empty($settings['copyright_title'])): ?><div class="copyright-text"><?php echo wp_kses_post($settings['copyright_title']); ?></div><?php endif; ?>
                        <div class="social-icon d-flex align-items-center">
                            <?php
                            if (!empty($copyright_icon_list)) {
                                foreach ($copyright_icon_list as $item) {
                                    $link = $item['link_item']['url'] ?? '#';
                                    echo '<a href="' . esc_url($link) . '">';
                                    echo '<i class="' . esc_attr($item['icon_item']['library']) . ' ' . esc_attr($item['icon_item']['value']) . ' "></i>';
                                    echo '</a>';
                                }
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Footer_V1());
