<?php

namespace Elementor;

class Footer_V2 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-footer-v2';
    }

    public function get_title(): string
    {
        return esc_html__('Footer V2', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_hf_widgets'];
    }

    public function get_keywords(): array
    {
        return ['footer-v2', 'footer', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'newsletter_content_section',
            [
                'label' => esc_html__('Newsletter', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_img',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'form_logo',
            [
                'label' => esc_html__('Logo Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'form_title',
            [
                'label' => esc_html__('Form Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Subscribe Newsletter', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'form_desc',
            [
                'label' => esc_html__('Form Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Stay updated with the latest trends, tips, and insights in air logistics. Discover smarter shipping solutions delivered straight to your inbox—fast, reliable, and industry-focused.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'form_shortcode',
            [
                'label' => esc_html__('Form Shortcode', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('[contact-form-7 id="41396fb" title="Newsletter One"]', 'trackngo-core'),
            ]
        );
        $this->add_control(
            '_icon_list',
            [
                'label' => esc_html__('Icon List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'icon_item',
                        'label' => esc_html__('Icon', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                    ],
                    [
                        'name' => 'link_item',
                        'label' => esc_html__('Link', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ icon_item.title }}}',
            ]
        );
        $this->end_controls_section();

        //contact
        $this->start_controls_section(
            'contact_content_section',
            [
                'label' => esc_html__('Address & Contact', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'contact_list',
            [
                'label' => esc_html__('Address List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'contact_title',
                        'label' => esc_html__('Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::WYSIWYG,
                        'default' => esc_html__('3891 Ranchview Dr.Richardson, California 6263', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'contact_icon',
                        'label' => esc_html__('Icon', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                    ]
                ],
                'title_field' => '{{{ contact_title }}}',
            ]
        );
        $this->end_controls_section();

        //menu one
        $this->start_controls_section(
            'menu_one_content_section',
            [
                'label' => esc_html__('Menu One', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'menu_one_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Service', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'menu_list_1',
            [
                'label' => esc_html__('Menu List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'menu_title',
                        'label' => esc_html__('Menu Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Freight Transportation', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'menu_link',
                        'label' => esc_html__('Link', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ menu_title }}}',
            ]
        );
        $this->end_controls_section();

        //menu two
        $this->start_controls_section(
            'menu_two_content_section',
            [
                'label' => esc_html__('Menu Two', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'menu_two_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Service', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'menu_list_2',
            [
                'label' => esc_html__('Menu List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'menu_title_two',
                        'label' => esc_html__('Menu Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Freight Transportation', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'menu_link_two',
                        'label' => esc_html__('Link', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ menu_title_two }}}',
            ]
        );
        $this->end_controls_section();


        //ciopyright area
        $this->start_controls_section(
            'copyright_content_section',
            [
                'label' => esc_html__('Copyright', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'copyright_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Service', 'trackngo-core'),
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->button_style($this, 'Form Button', '.ixl-footer-newsletter button');

        //form style controls
        $this->start_controls_section(
            'form_style_option',
            [
                'label' => esc_html__('Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'field_typography',
                'selector' => '{{WRAPPER}} .ixl-footer-newsletter input',
            ]
        );
        $this->add_control(
            'form_bg_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ixl-footer-newsletter input' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_bg-c',
            [
                'label' => esc_html__('Background Color', 'trackngo-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ixl-footer-newsletter input' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_box_shadow',
                'selector' => '{{WRAPPER}} .ixl-footer-newsletter input',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_border',
                'selector' => '{{WRAPPER}} .ixl-footer-newsletter input',
            ]
        );
        $this->end_controls_section();


        $trackngoElementorInit->typography_style($this, 'Menu Title', '.widget-head h3');

        $trackngoElementorInit->typography_style($this, 'Menu Item', '.list-area li a');

        $trackngoElementorInit->typography_style($this, 'Address', '.footer-contact-2 .content div');

        $trackngoElementorInit->typography_style($this, 'Newsletter Title', '.newsletter-box h3');

        $trackngoElementorInit->typography_style($this, 'Newsletter Description', '.newsletter-box p');

        $trackngoElementorInit->section_style($this, 'Copyright Section', '.footer-bottom');

        $trackngoElementorInit->typography_style($this, 'Copyright Text', '.copyright-text');


        // Social Icon Style
        $this->start_controls_section(
            'icon_style_section',
            [
                'label' => esc_html__('Social Icon', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'icon_style_tabs'
        );
        $this->start_controls_tab(
            'icon_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_width',
            [
                'label' => esc_html__('Width', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .social-icon a i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .social-icon a',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'icon_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color_hover',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border_hover',
                'selector' => '{{WRAPPER}} .social-icon a:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $form_shortcode = $settings['form_shortcode'] ?? '';
        $menu_list_1 = $settings['menu_list_1'] ?? [];
        $menu_list_2 = $settings['menu_list_2'] ?? [];
        $_icon_list = $settings['_icon_list'] ?? [];
        $contact_list = $settings['contact_list'] ?? [];
?>
        <footer class="footer-section-2 bg-cover fix" style="background-image:url('<?php echo esc_url($settings['bg_img']['url']); ?>');">
            <?php if (!empty(wp_get_attachment_image($settings['form_logo']['id']))): ?>
                <div class="footer-logo text-center">
                    <a href="<?php echo esc_url(home_url('/')); ?>">
                        <?php echo wp_get_attachment_image($settings['form_logo']['id'], 'full'); ?>
                    </a>
                </div>
            <?php endif; ?>
            <div class="container">
                <div class="footer-widget-wrapper style-2">
                    <div class="row g-4 justify-content-between">
                        <div class=" col-xl-6 col-lg-6 ">
                            <div class="row">
                                <div class="col-lg-6 col-md-6 col-sm-6">
                                    <div class="single-footer-widget">
                                        <?php if (!empty($settings['menu_one_title'])): ?>
                                            <div class="widget-head">
                                                <h3><?php echo esc_html($settings['menu_one_title']); ?></h3>
                                            </div>
                                        <?php endif;

                                        if (!empty($menu_list_1)):
                                        ?>
                                            <ul class="list-area">
                                                <?php
                                                foreach ($menu_list_1 as $item) {
                                                    $menu_title = $item['menu_title'] ?? '';
                                                    $menu_link = $item['menu_link']['url'] ?? '#';
                                                    echo '<li><a href="' . esc_url($menu_link) . '">' . esc_html($menu_title) . '</a></li>';
                                                }
                                                ?>
                                            </ul>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6">
                                    <div class="single-footer-widget">
                                        <?php if (!empty($settings['menu_two_title'])): ?>
                                            <div class="widget-head">
                                                <h3><?php echo esc_html($settings['menu_two_title']); ?></h3>
                                            </div>
                                        <?php endif;
                                        if (!empty($menu_list_2)):
                                        ?>
                                            <ul class="list-area">
                                                <?php
                                                foreach ($menu_list_2 as $item) {
                                                    $menu_title_two = $item['menu_title_two'] ?? '';
                                                    $menu_link_two = $item['menu_link_two']['url'] ?? '#';
                                                    echo '<li><a href="' . esc_url($menu_link_two) . '">' . esc_html($menu_title_two) . '</a></li>';
                                                }
                                                ?>
                                            </ul>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php if (!empty($contact_list)): ?>
                                <ul class="footer-contact-2">
                                    <?php foreach ($contact_list as $item): ?>
                                        <li>
                                            <div class="icon">
                                                <i class="<?php echo esc_attr($item['contact_icon']['library']) . ' ' . esc_attr($item['contact_icon']['value']); ?>"></i>
                                            </div>
                                            <div class="content">
                                                <div><?php echo wp_kses_post($item['contact_title']); ?></div>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                        <div class=" col-xl-5 col-lg-5 ">
                            <div class="newsletter-box">
                                <?php if (!empty($settings['form_title'])): ?><h3><?php echo esc_html($settings['form_title']); ?></h3><?php endif; ?>
                                <?php if (!empty($settings['form_desc'])): ?><p><?php echo esc_html($settings['form_desc']); ?></p><?php endif; ?>
                                <?php if (!empty($form_shortcode)): ?>
                                    <div class="ixl-footer-newsletter">
                                        <?php echo do_shortcode($form_shortcode); ?>
                                    </div>
                                <?php endif; ?>
                                <?php if (!empty($_icon_list)): ?>
                                    <div class="social-icon d-flex align-items-center">
                                        <?php
                                        foreach ($_icon_list as $item) {
                                            $link = $item['link_item']['url'] ?? '#';
                                            echo '<a href="' . esc_url($link) . '">';
                                            echo '<i class="' . esc_attr($item['icon_item']['library']) . ' ' . esc_attr($item['icon_item']['value']) . ' "></i>';
                                            echo '</a>';
                                        }
                                        ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php if (!empty($settings['copyright_title'])): ?>
                <div class="footer-bottom">
                    <div class="container">
                        <div class="footer-bottom-wrapper justify-content-center">
                            <div class="copyright-text"><?php echo wp_kses_post($settings['copyright_title']); ?></div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </footer>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Footer_V2());
