<?php

namespace Elementor;

class Footer_V3 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-footer-v3';
    }

    public function get_title(): string
    {
        return esc_html__('Footer V3', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_hf_widgets'];
    }

    public function get_keywords(): array
    {
        return ['footer-v3', 'footer', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'newsletter_content_section',
            [
                'label' => esc_html__('Newsletter', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_img',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'form_logo',
            [
                'label' => esc_html__('Logo Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'form_title',
            [
                'label' => esc_html__('Form Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Subscribe Newsletter', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'form_shortcode',
            [
                'label' => esc_html__('Form Shortcode', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('[contact-form-7 id="41396fb" title="Newsletter One"]', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'footer_desc',
            [
                'label' => esc_html__('Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('There are emits consectetur notted aetinciduns pisicing jutre elit sed at eiusmode tempors.There are emits consectetur notted aetincidun', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_title',
            [
                'label' => esc_html__('Icon Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Follow Us', 'trackngo-core'),
            ]
        );
        $this->add_control(
            '_icon_list',
            [
                'label' => esc_html__('Icon List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'icon_item',
                        'label' => esc_html__('Icon', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                    ],
                    [
                        'name' => 'link_item',
                        'label' => esc_html__('Link', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ icon_item.title }}}',
            ]
        );
        $this->end_controls_section();

        //contact area
        $this->start_controls_section(
            'contact_content_section',
            [
                'label' => esc_html__('Contact', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'contact_title',
            [
                'label' => esc_html__('Contact Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Contact Us', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'contact_list',
            [
                'label' => esc_html__('Contact List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'contact_list_title',
                        'label' => esc_html__('Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('3891 Ranchview Dr. Richardson, California 62639', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'contact_list_icon',
                        'label' => esc_html__('Icon', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                    ],
                ],
                'title_field' => '{{{ contact_list_title }}}',
            ]
        );
        $this->add_control(
            'open_hour_title',
            [
                'label' => esc_html__('Open Hour Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Contact Us', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'open_hour_desc',
            [
                'label' => esc_html__('Open Hour Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'label_block' => true,
                'default' => esc_html__('Contact Us', 'trackngo-core'),
            ]
        );
        $this->end_controls_section();

        //menu one
        $this->start_controls_section(
            'menu_one_content_section',
            [
                'label' => esc_html__('Menu One', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'menu_one_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Service', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'menu_list_1',
            [
                'label' => esc_html__('Menu List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'menu_title',
                        'label' => esc_html__('Menu Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Freight Transportation', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'menu_link',
                        'label' => esc_html__('Link', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ menu_title }}}',
            ]
        );
        $this->end_controls_section();

        //menu one
        $this->start_controls_section(
            'gallery_content_section',
            [
                'label' => esc_html__('Gallery', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'gallery_title',
            [
                'label' => esc_html__('Gallery Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Gallery', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'gallery_list',
            [
                'label' => esc_html__('Gallery List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'gallery_image',
                        'label' => esc_html__('Choose Image', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                ],
                'title_field' => '{{{ gallery_image.title }}}',
            ]
        );
        $this->end_controls_section();


        //copyright area
        $this->start_controls_section(
            'copyright_content_section',
            [
                'label' => esc_html__('Copyright', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'copyright_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Service', 'trackngo-core'),
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->typography_style($this, 'Form Title', '.footer-top-3 h3');

        $trackngoElementorInit->button_style($this, 'Form Button', '.page3-form button');

        //form style controls
        $this->start_controls_section(
            'form_style_option',
            [
                'label' => esc_html__('Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'field_typography',
                'selector' => '{{WRAPPER}} .page3-form input',
            ]
        );
        $this->add_control(
            'form_bg_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .page3-form input' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_bg-c',
            [
                'label' => esc_html__('Background Color', 'trackngo-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .page3-form input' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_box_shadow',
                'selector' => '{{WRAPPER}} .page3-form input',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_border',
                'selector' => '{{WRAPPER}} .page3-form input',
            ]
        );
        $this->end_controls_section();


        $trackngoElementorInit->typography_style($this, 'Description', '.footer-content p');

        $trackngoElementorInit->typography_style($this, 'Icon Item', '.footer-content span');

        $trackngoElementorInit->typography_style($this, 'Contact, Open Hours, Menu, Gallery Title', '.widget-head h3, .content h3, .single-footer-widget h3');

        $trackngoElementorInit->typography_style($this, 'Contact, Open Hours, Menu Item Description', '.list-area li a, .footer-contact-3 li, .content span');

        $trackngoElementorInit->section_style($this, 'Copyright Section', '.footer-bottom');

        $trackngoElementorInit->typography_style($this, 'Copyright Text', '.copyright-text');


        // Social Icon Style
        $this->start_controls_section(
            'icon_style_section',
            [
                'label' => esc_html__('Social Icon', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'icon_style_tabs'
        );
        $this->start_controls_tab(
            'icon_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_width',
            [
                'label' => esc_html__('Width', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .social-icon a i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .social-icon a',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'icon_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color_hover',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border_hover',
                'selector' => '{{WRAPPER}} .social-icon a:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $form_shortcode = $settings['form_shortcode'] ?? '';
        $menu_list_1 = $settings['menu_list_1'] ?? [];
        $_icon_list = $settings['_icon_list'] ?? [];
        $contact_list = $settings['contact_list'] ?? [];
        $gallery_list = $settings['gallery_list'] ?? [];
?>
        <footer class="footer-section-3 fix  bg-cover" style="background-image:url('<?php echo esc_url($settings['bg_img']['url']); ?>');">
            <div class="container">
                <div class="footer-top-3 d-flex align-items-center justify-content-between">
                    <?php if (!empty($settings['form_title'])): ?><h3><?php echo esc_html($settings['form_title']); ?></h3><?php endif; ?>
                    <?php if (!empty($form_shortcode)): ?>
                        <div class="page3-form">
                            <?php echo do_shortcode($form_shortcode); ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="footer-widget-wrapper style-3">
                    <div class="row">
                        <div class="col-xl-3 col-lg-4 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                            <div class="single-footer-widget">
                                <?php if (!empty($settings['form_logo']['id'])): ?>
                                    <div class="widget-head">
                                        <a href="<?php echo esc_url(home_url('/')); ?>">
                                            <?php echo wp_get_attachment_image($settings['form_logo']['id'], 'full'); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <div class="footer-content">
                                    <?php if (!empty($settings['footer_desc'])) {
                                        echo '<p>' . esc_html($settings['footer_desc']) . '</p>';
                                    } ?>
                                    <?php if (!empty($settings['icon_title'])) {
                                        echo '<span>' . esc_html($settings['icon_title']) . '</span>';
                                    } ?>
                                    <?php if (!empty($_icon_list)): ?>
                                        <div class="social-icon d-flex align-items-center">
                                            <?php
                                            foreach ($_icon_list as $item) {
                                                $link = $item['link_item']['url'] ?? '#';
                                                echo '<a href="' . esc_url($link) . '">';
                                                echo '<i class="' . esc_attr($item['icon_item']['library']) . ' ' . esc_attr($item['icon_item']['value']) . ' "></i>';
                                                echo '</a>';
                                            }
                                            ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-4 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                            <div class="single-footer-widget">
                                <?php if (!empty($settings['contact_title'])): ?>
                                    <div class="widget-head">
                                        <h3><?php echo esc_html($settings['contact_title']); ?></h3>
                                    </div>
                                <?php endif; ?>
                                <ul class="footer-contact-3">
                                    <?php
                                    if (!empty($contact_list)) {
                                        foreach ($contact_list as $item) {
                                    ?>
                                            <li>
                                                <div class="icon-location">
                                                    <i class="<?php echo esc_attr($item['contact_list_icon']['library']) . ' ' . esc_attr($item['contact_list_icon']['value']); ?>"></i>
                                                    <div class="content">
                                                        <span><?php echo esc_html($item['contact_list_title']); ?></span>
                                                    </div>
                                                </div>
                                            </li>
                                    <?php
                                        }
                                    }
                                    ?>

                                </ul>
                                <div class="content">
                                    <?php
                                    if (!empty($settings['open_hour_title'])): ?>
                                        <h3><?php echo esc_html($settings['open_hour_title']); ?></h3>
                                    <?php endif; ?>
                                    <?php
                                    if (!empty($settings['open_hour_desc'])) echo '<div>' . wp_kses_post($settings['open_hour_desc']) . '</div>';
                                    ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-4 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                            <div class="single-footer-widget">
                                <?php if (!empty($settings['menu_one_title'])): ?>
                                    <div class="widget-head">
                                        <h3><?php echo esc_html($settings['menu_one_title']); ?></h3>
                                    </div>
                                <?php endif;

                                if (!empty($menu_list_1)):
                                ?>
                                    <ul class="list-area">
                                        <?php
                                        foreach ($menu_list_1 as $item) {
                                            $menu_title = $item['menu_title'] ?? '';
                                            $menu_link = $item['menu_link']['url'] ?? '#';
                                            echo '<li><a href="' . esc_url($menu_link) . '">' . esc_html($menu_title) . '</a></li>';
                                        }
                                        ?>
                                    </ul>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-4 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                            <div class="single-footer-widget">
                                <div class="widget-head">
                                    <?php if (!empty($settings['gallery_title'])) echo '<h3>' . esc_html($settings['gallery_title']) . '</h3>' ?>
                                </div>
                                <?php if (!empty($gallery_list)): ?>
                                    <div class="gallery-items d-flex align-items-center">
                                        <?php
                                        foreach ($gallery_list as $index =>  $item):
                                            if ($index <= 2):
                                                if (!empty($item['gallery_image']['id'])):
                                        ?>
                                                    <div class="gallery-image">
                                                        <a href="<?php echo esc_url($item['gallery_image']['id']); ?>" class="img-popup">
                                                            <?php echo wp_get_attachment_image($item['gallery_image']['id'], 'full'); ?>
                                                        </a>
                                                    </div>
                                        <?php
                                                endif;
                                            endif;
                                        endforeach;
                                        ?>
                                    </div>
                                <?php endif; ?>
                                <?php if (!empty($gallery_list)): ?>
                                    <div class="gallery-items d-flex align-items-center">
                                        <?php
                                        foreach ($gallery_list as $index =>  $item):
                                            if ($index <= 5 && $index > 2):
                                                if (!empty($item['gallery_image']['id'])):
                                        ?>
                                                    <div class="gallery-image">
                                                        <a href="<?php echo esc_url($item['gallery_image']['id']); ?>" class="img-popup">
                                                            <?php echo wp_get_attachment_image($item['gallery_image']['id'], 'full'); ?>
                                                        </a>
                                                    </div>
                                        <?php
                                                endif;
                                            endif;
                                        endforeach;
                                        ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php if (!empty($settings['copyright_title'])): ?>
                <div class="footer-bottom">
                    <div class="container">
                        <div class="footer-bottom-wrapper justify-content-center">
                            <div><?php echo wp_kses_post($settings['copyright_title']); ?></div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </footer>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Footer_V3());
