<?php

namespace Elementor;

class Header_V3 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-header-three';
    }

    public function get_title(): string
    {
        return esc_html__('Header V3', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_hf_widgets'];
    }

    public function get_keywords(): array
    {
        return ['header-three', 'menu', 'header', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'h1_header_style',
            [
                'label' => esc_html__('Header Style', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'header-1',
                'label_block' => true,
                'options' => trackngo_menu_selector(),
            ]
        );
        $this->add_control(
            'logo_image',
            [
                'label' => esc_html__('Logo Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'mobile_logo_image',
            [
                'label' => esc_html__('Mobile Logo Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'show_search',
            [
                'label' => esc_html__('Show Search', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'trackngo-core'),
                'label_off' => esc_html__('Hide', 'trackngo-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'call_title',
            [
                'label' => esc_html__('Call Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Make A Call', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'call_number',
            [
                'label' => esc_html__('Call Number', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('+1 436 000 4395', 'trackngo-core'),
            ]
        );

        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Offcanvas Button Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Get A Quote', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Offcanvas Button Link', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        //contact list
        $this->start_controls_section(
            'contact_content_section',
            [
                'label' => esc_html__('Contact', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'contact_list',
            [
                'label' => esc_html__('Contact List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'contact_title',
                        'label' => esc_html__('Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('Infotrackgo@email.com', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'contact_icon',
                        'label' => esc_html__('Icon', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                    ]
                ],
                'title_field' => '{{{ contact_title }}}',
            ]
        );
        $this->end_controls_section();

        // mobile contact list
        $this->start_controls_section(
            'contact_content_section_mobile',
            [
                'label' => esc_html__('Offcanvas Contact', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'mobile_contact_desc',
            [
                'label' => esc_html__('Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => esc_html__('Nullam dignissim, ante scelerisque the is euismod fermentum odio sem semper the is erat, a feugiat leo urna eget eros. Duis Aenean a imperdiet risus.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'mobile_contact_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Contact Info', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'mobile_contact_list',
            [
                'label' => esc_html__('Offcanvas Contact List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'mobile_contact_title',
                        'label' => esc_html__('Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('Infotrackgo@email.com', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'mobile_contact_icon',
                        'label' => esc_html__('Icon', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                    ]
                ],
                'title_field' => '{{{ mobile_contact_title }}}',
            ]
        );
        $this->end_controls_section();

        // offcanvas social list
        $this->start_controls_section(
            'content_section_offcanvas_icon',
            [
                'label' => esc_html__('Social Icon', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'icon_title_',
            [
                'label' => esc_html__('Icon Text', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('+ Track Your Order', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'offcanvas_social_icon_list',
            [
                'label' => esc_html__('Offcanvas Icon List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'offcanvas_contact_icon',
                        'label' => esc_html__('Icon', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                    ],
                    [
                        'name' => 'offcanvas_contact_link',
                        'label' => esc_html__('Link', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ offcanvas_contact_icon.title }}}',
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Menu Body', '.header-main');

        $trackngoElementorInit->section_style($this, 'Top Bar Body', '.header-section-3 .header-wrapper-3 .head-right-item .header-top-wrapper-3');

        $trackngoElementorInit->typography_style($this, 'Menu', '.il-main-navigation a, .il-main-navigation ul .menu-item-has-children::after');

        $trackngoElementorInit->typography_style($this, 'Contact', '.header-section-3 .header-wrapper-3 .head-right-item .header-top-wrapper-3 .head-top li');

        $trackngoElementorInit->section_style($this, 'Call Body', '.header-section-3 .header-wrapper-3 .header-3::before');

        $trackngoElementorInit->typography_style($this, 'Call Title', '.header-section-3 .header-wrapper-3 .header-3 .header-right .header-client-info .content p');

        $trackngoElementorInit->typography_style($this, 'Call Number', '.header-section-3 .header-wrapper-3 .header-3 .header-right .header-client-info .content h4');

        $trackngoElementorInit->typography_style($this, 'Description', '.offcanvas__wrapper .offcanvas__content .text');

        $trackngoElementorInit->typography_style($this, 'Offcanvas Contact Title', '.offcanvas__contact h4');

        $trackngoElementorInit->typography_style($this, 'Offcanvas Contact List', '.offcanvas__wrapper .offcanvas__content .offcanvas__contact ul li a');

        $trackngoElementorInit->button_style($this, 'Offcanvas Button', '.main-button .theme-btn');

        $trackngoElementorInit->typography_style($this, 'Icon Text', '.header-section-3 .header-wrapper-3 .head-right-item .header-top-wrapper-3 .heads-right p');

        // offcanvas contact Icon Style
        $this->start_controls_section(
            'offcanvs_contac_icon_style_section',
            [
                'label' => esc_html__('Offcanvs Contact Icon', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'offcanvas_icon_width',
            [
                'label' => esc_html__('Width', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .offcanvas__wrapper .offcanvas__content .offcanvas__contact ul li .offcanvas__contact-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'offcanvas_icon_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .offcanvas__wrapper .offcanvas__content .offcanvas__contact ul li .offcanvas__contact-icon i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        // Social Icon Style
        $this->start_controls_section(
            'icon_style_section',
            [
                'label' => esc_html__('Social Icon', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'icon_style_tabs'
        );
        $this->start_controls_tab(
            'icon_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_width',
            [
                'label' => esc_html__('Width', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .social-icon a i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .social-icon a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .social-icon a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .social-icon a',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'icon_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a:hover i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .social-icon a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color_hover',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon a:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border_hover',
                'selector' => '{{WRAPPER}} .social-icon a:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        //left shape
        $this->start_controls_section(
            'left_shape_style_section',
            [
                'label' => esc_html__('Left Shape', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'left_shape_color',
            [
                'label' => esc_html__('Background Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-section-3::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $contact_lists = $settings['contact_list'] ? $settings['contact_list'] : [];
        $mobile_contact_list = $settings['mobile_contact_list'] ? $settings['mobile_contact_list'] : [];
        $offcanvas_social_icon_list = $settings['offcanvas_social_icon_list'] ? $settings['offcanvas_social_icon_list'] : [];
?>

        <!-- Offcanvas Area Start -->
        <div class="fix-area">
            <div class="offcanvas__info">
                <div class="offcanvas__wrapper">
                    <div class="offcanvas__content">
                        <div class="offcanvas__top mb-5 d-flex justify-content-between align-items-center">

                            <?php if (!empty($settings['mobile_logo_image']['id'])): ?>
                                <div class="offcanvas__logo">
                                    <a href="<?php echo esc_url(home_url('/')); ?>" class="header-logo">
                                        <?php echo wp_get_attachment_image($settings['mobile_logo_image']['id'], 'full'); ?>
                                    </a>
                                </div>
                            <?php endif; ?>

                            <div class="offcanvas__close">
                                <button>
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                        <?php if (!empty($settings['mobile_contact_desc'])): ?><p class="text d-none d-lg-block"><?php echo esc_html($settings['mobile_contact_desc']); ?></p><?php endif; ?>

                        <div class="mobile-menu fix mb-3"></div>
                        <div class="offcanvas__contact">
                            <?php if (!empty($settings['mobile_contact_title'])) echo '<h4>' . $settings['mobile_contact_title'] . '</h4>'; ?>

                            <?php if (!empty($mobile_contact_list)): ?>
                                <ul>
                                    <?php
                                    foreach ($mobile_contact_list as $mobile_contact) : ?>
                                        <li class="d-flex align-items-center">
                                            <?php if (!empty($mobile_contact['mobile_contact_icon']['library'])): ?>
                                                <div class="offcanvas__contact-icon">
                                                    <i class="<?php echo esc_attr($mobile_contact['mobile_contact_icon']['library'] . ' ' . $mobile_contact['mobile_contact_icon']['value']); ?>"></i>
                                                </div>
                                            <?php endif; ?>
                                            <div class="offcanvas__contact-text">
                                                <a target="_blank" href="#"><?php echo esc_html($mobile_contact['mobile_contact_title']); ?></a>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>

                            <?php if (!empty($settings['btn_title'])): ?>
                                <div class="main-button mt-4">
                                    <a href="<?php echo esc_url($settings['btn_link']['url']); ?>"> <span class="theme-btn"> <?php echo esc_html($settings['btn_title']); ?> </span><span class="arrow-btn"><i class="fa-regular fa-arrow-up-right"></i></span></a>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($offcanvas_social_icon_list)): ?>
                                <div class="social-icon d-flex align-items-center">
                                    <?php
                                    foreach ($offcanvas_social_icon_list as $icon): ?>
                                        <a href="<?php echo esc_url($icon['offcanvas_contact_link']['url']); ?>"><i class="<?php echo esc_attr($icon['offcanvas_contact_icon']['library'] . ' ' . $icon['offcanvas_contact_icon']['value']); ?>"></i></a>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="offcanvas__overlay"></div>

        <!-- Header Section Start -->
        <header class="header-section-3">
            <div class="container">
                <div class="header-wrapper-3">

                    <?php if (!empty($settings['logo_image']['id'])): ?>
                        <a href="<?php echo esc_url(home_url('/')); ?>" class="heade-logo d-none d-xxl-block z-1">
                            <?php echo wp_get_attachment_image($settings['logo_image']['id'], 'full'); ?>
                        </a>
                    <?php endif; ?>


                    <div class="head-right-item">
                        <div class="header-top-wrapper-3">

                            <?php if (!empty($contact_lists)): ?>
                                <ul class="head-top ps-0 ps-xxl-4">
                                    <?php
                                    foreach ($contact_lists as $contact) : ?>
                                        <li>
                                            <i class="<?php echo esc_attr($contact['contact_icon']['library'] . ' ' . $contact['contact_icon']['value']); ?>"></i>
                                            <span><?php echo esc_html($contact['contact_title']); ?></span>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>

                            <div class="heads-right">
                                <?php if (!empty($settings['icon_title_'])) echo '<p>' . esc_html($settings['icon_title_']) . '</p>' ?>
                                <?php if (!empty($offcanvas_social_icon_list)): ?>
                                    <div class="social-icon d-flex align-items-center">
                                        <?php
                                        foreach ($offcanvas_social_icon_list as $icon): ?>
                                            <a href="<?php echo esc_url($icon['offcanvas_contact_link']['url']); ?>"><i class="<?php echo esc_attr($icon['offcanvas_contact_icon']['library'] . ' ' . $icon['offcanvas_contact_icon']['value']); ?>"></i></a>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div id="header-sticky" class="header-3">
                            <div class="mega-menu-wrapper">
                                <div class="header-main">
                                    <div class="header-left d-xxl-none">

                                        <?php if (!empty($settings['mobile_logo_image']['id'])): ?>
                                            <div class="logo">
                                                <a href="<?php echo esc_url(home_url('/')); ?>" class="header-logo">
                                                    <?php echo wp_get_attachment_image($settings['mobile_logo_image']['id'], 'full'); ?>
                                                </a>
                                            </div>
                                        <?php endif; ?>

                                    </div>
                                    <div class="mean__menu-wrapper ralt">
                                        <div class="main-menu">
                                            <nav id="mobile-menu" class="il-main-navigation">
                                                <?php
                                                wp_nav_menu(array(
                                                    'menu'        => $settings['h1_header_style'],
                                                    'menu_id' => 'main-nav',
                                                    'link_before' => '<span>',
                                                    'link_after' => '</span>',
                                                    'container' => false,
                                                    'fallback_cb' => 'Trackngo_Bootstrap_Navwalker::fallback',
                                                ));
                                                ?>
                                            </nav>
                                        </div>
                                    </div>
                                    <div class="header-right d-flex justify-content-end align-items-center">
                                        <?php if ('yes' == $settings['show_search']): ?><a href="#0" class="search-trigger search-icon"><i class="fal fa-search"></i></a><?php endif; ?>
                                        <div class="header-client-info">
                                            <div class="icon">
                                                <i class="fa-solid fa-phone"></i>
                                            </div>

                                            <?php if (!empty($settings['call_number'])): ?>
                                                <div class="content">
                                                    <?php if (!empty($settings['call_title'])): ?><p><?php echo esc_html($settings['call_title']); ?></p><?php endif; ?>
                                                    <?php if (!empty($settings['call_number'])): ?><h4><?php echo esc_html($settings['call_number']); ?></h4><?php endif; ?>
                                                </div>
                                            <?php endif; ?>

                                        </div>
                                        <div class="header__hamburger">
                                            <div class="sidebar__toggle">
                                                <i class="fas fa-bars"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </header>


        <!-- Search Area Start -->
        <div class="search-wrap">
            <div class="search-inner">
                <i class="fas fa-times search-close" id="search-close"></i>
                <div class="search-cell">
                    <form role="search" method="get" class="search-form" action="<?php echo esc_url(home_url('/')); ?>">
                        <div class="search-field-holder">
                            <input type="search" class="main-search-input" name="s" value="<?php echo get_search_query(); ?>" placeholder="<?php esc_attr_e('Search...', 'trackngo-core'); ?>" />
                        </div>
                    </form>
                </div>
            </div>
        </div>


<?php
    }
}
Plugin::instance()->widgets_manager->register(new Header_V3());
