<?php

namespace Elementor;

class Hero_Title extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-title';
    }

    public function get_title(): string
    {
        return esc_html__('Heading', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['title', 'heading', 'header', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title_image_before',
            [
                'label' => esc_html__('Sub Title Before Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'sub-title',
            [
                'label' => esc_html__('Sub Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('OUR SERVICES', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'sub_title_image_after',
            [
                'label' => esc_html__('Sub Title After Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Your Freight, Our Priority.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title Tag', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => esc_html__('H1', 'trackngo-core'),
                        'icon' => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => esc_html__('H2', 'trackngo-core'),
                        'icon' => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => esc_html__('H3', 'trackngo-core'),
                        'icon' => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => esc_html__('H4', 'trackngo-core'),
                        'icon' => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => esc_html__('H5', 'trackngo-core'),
                        'icon' => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => esc_html__('H6', 'trackngo-core'),
                        'icon' => 'eicon-editor-h6',
                    ],
                ],
                'default' => 'h2',
                'toggle' => true,
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('We’re more than a freight carrier—we’re your long-term logistics partner. From the first mile to the final destination, our experienced team ensures every shipment is handled with care, precision, and real-time visibility.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'add_animation',
            [
                'label' => esc_html__('Add Animation', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'trackngo-core'),
                'label_off' => esc_html__('Hide', 'trackngo-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('300', 'trackngo-core'),
                'condition' => [
                    'add_animation' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();


        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();
        $trackngoElementorInit->typography_style($this, 'Sub Title', '.IXL-sub-title');
        $trackngoElementorInit->typography_style($this, 'Title', '.IXL-title');
        $trackngoElementorInit->typography_style($this, 'Description', '.IXL-desc');
    }
    protected function render(): void
    {

        $settings = $this->get_settings_for_display();
        $add_animation = $settings['add_animation'];
        $animation_delay = !empty($settings['animation_delay']) ? $settings['animation_delay'] : '300';

        if ('yes' == $add_animation) {
            $class_animation = 'wow fadeInUp';
            $data_animation = 'data-wow-delay="' . $animation_delay . 'ms"';
        } else {
            $class_animation = '';
            $data_animation = '';
        }

        if (!empty($settings['sub-title'])) {
            echo '<h6 class="IXL-sub-title ' . esc_attr($class_animation) . '" data-wow-delay="' . esc_attr($data_animation) . '">' . wp_get_attachment_image($settings['sub_title_image_before']['id'], 'full') . ' ' . esc_html($settings['sub-title']) . ' ' .  wp_get_attachment_image($settings['sub_title_image_after']['id'], 'full') . '</h6>';
        }

        if (!empty($settings['title'])) {
            $tag = isset($settings['title_tag']) ? $settings['title_tag'] : 'h2';
            echo '<' . esc_html($tag) . ' class="IXL-title ' . esc_attr($class_animation) . '" data-wow-delay="' . esc_attr($data_animation) . '">';
            echo esc_html($settings['title']);
            echo '</' . esc_html($tag) . '>';
        }
        if (!empty($settings['description'])) {
            echo '<div class="IXL-desc ' . esc_attr($class_animation) . '" data-wow-delay="' . esc_attr($data_animation) . '">' . wp_kses_post($settings['description']) . '</div>';
        }
    }
}
Plugin::instance()->widgets_manager->register(new Hero_Title());
