<?php

namespace Elementor;

class Hero_V3 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-hero-three';
    }

    public function get_title(): string
    {
        return esc_html__('Section Hero V3', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['header-two', 'menu', 'header', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section_hv3',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'hv3_sub_title',
            [
                'label' => esc_html__('Sub Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('WELCOME TO TRACKNGO SYSTEM', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'hv3_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('End-to-End Land Freight You Can Count On.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'hv3_desc',
            [
                'label' => esc_html__('Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('We provide dependable land freight services tailored to your needs local or cross-border. With real-time tracking, flexible routes, and on-time delivery.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'hv3_btn_title',
            [
                'label' => esc_html__('Button Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('VIEW CLASS SCHEDULE', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'hv3_btn_link',
            [
                'label' => esc_html__('Button Link', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'hv3_vdo_btn_title',
            [
                'label' => esc_html__('Video Button Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('PLAY VIDEO', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'hv3_vdo_btn_url',
            [
                'label' => esc_html__('Video Url', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'images_section_hv3',
            [
                'label' => esc_html__('Images', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'hv3_title_image',
            [
                'label' => esc_html__('Title Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'hv3_hero_image',
            [
                'label' => esc_html__('Hero Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'hv3_bg_image',
            [
                'label' => esc_html__('Backround Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngo_init = \Trackngo_Elementor_Widget_Init::getInstance();

        // Sub Title style
        $trackngo_init->typography_style($this, 'Sub Title', '.section-title h6');

        // Title style
        $trackngo_init->typography_style($this, 'Title', '.section-title .text-white');

        // Description style
        $trackngo_init->typography_style($this, 'Description', '.hero-text');

        //button style
        $trackngo_init->button_style($this, 'Main Button', '.main-button .theme-btn');

        //arrow button style
        $trackngo_init->button_style($this, 'Play Button', '.video-btn .video-text');

        $trackngo_init->button_style($this, 'Play icon', '.video-btn i');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $sub_title = $settings['hv3_sub_title'];
        $title = $settings['hv3_title'];
        $desc = $settings['hv3_desc'];
        $btn_title = $settings['hv3_btn_title'];
        $btn_link = $settings['hv3_btn_link']['url'];
        $bg_image = $settings['hv3_bg_image']['url'];
        $title_image = $settings['hv3_title_image']['id'];
        $hero_image = $settings['hv3_hero_image']['id'];
?>
        <section class="hero-section hero-3 bg-cover fix" style="background-image: url(<?php echo esc_url($bg_image); ?>);">
            <div class="row g-4 align-items-center">
                <div class="col-lg-6">
                    <div class="hero-content">
                        <div class="section-title mb-0">
                            <?php if (!empty($sub_title)): ?><h6 class="wow fadeInUp"><?php echo wp_get_attachment_image($title_image, 'full'); ?><?php echo esc_html($sub_title); ?></h6><?php endif; ?>
                            <?php if (!empty($title)): ?><h1 class="text-white wow fadeInUp" data-wow-delay=".2s"><?php echo esc_html($title); ?></h1><?php endif; ?>
                        </div>
                        <?php if (!empty($desc)): ?><p class="hero-text wow fadeInUp" data-wow-delay=".3s"><?php echo esc_html($desc); ?></p><?php endif; ?>
                        <div class="hero-button">
                            <?php if ($btn_title): ?>
                                <div class="main-button mt-0 wow fadeInUp" data-wow-delay=".5s">
                                    <a href="<?php echo esc_url($btn_link); ?>"> <span class="theme-btn"><?php echo esc_html($btn_title); ?></span><span class="arrow-btn"><i class="fa-regular fa-arrow-up-right"></i></span></a>
                                </div>
                            <?php endif; ?>

                            <?php if ($settings['hv3_vdo_btn_title'] || $settings['hv3_vdo_btn_url']['url']): ?>
                                <a href="<?php echo esc_url($settings['hv3_vdo_btn_url']['url']); ?>" class="video-btn video-popup wow fadeInUp" data-wow-delay=".5s">
                                    <span class="video-text">
                                        <?php echo esc_html($settings['hv3_vdo_btn_title']); ?>
                                    </span>
                                    <i class="fas fa-play"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 wow fadeInUp" data-wow-delay=".3s">
                    <?php if (!empty($hero_image)): ?>
                        <div class="hero-image">
                            <?php echo wp_get_attachment_image($hero_image, 'full'); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Hero_V3());
