<?php

namespace Elementor;

class Image_Text_Carousel extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-image-text-carousel';
    }

    public function get_title(): string
    {
        return esc_html__('Image & Text Carousel', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['image-carousel', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'list',
            [
                'label' => esc_html__('Repeater List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'list_title',
                        'label' => esc_html__('Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Speed', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'list_image',
                        'label' => esc_html__('Choose Image', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngo_init = \Trackngo_Elementor_Widget_Init::getInstance();

        // Sub Title style
        $trackngo_init->section_style($this, 'Section', '.marque-section');
        $trackngo_init->typography_style($this, 'Title Style', '.marque-items h3');
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="marque-section">
            <div class="swiper marque-slider">
                <div class="swiper-wrapper slide-transtion">
                    <?php
                    if (!empty($settings['list'])):
                        foreach ($settings['list'] as $index => $item) :

                            $style_Two_Class = ($index % 2 == 1) ? 'style-2' : '';
                    ?>
                            <div class="swiper-slide brand-slide-element">
                                <div class="marque-items <?php echo esc_attr($style_Two_Class); ?>">
                                    <?php echo wp_get_attachment_image($item['list_image']['id'], 'full'); ?>
                                    <?php if (!empty($item['list_title'])): ?><h3><?php echo esc_html($item['list_title']); ?></h3><?php endif; ?>
                                </div>
                            </div>
                    <?php
                        endforeach;
                    endif;
                    ?>
                </div>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Image_Text_Carousel());
