<?php

namespace Elementor;

class Image extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-image';
    }

    public function get_title(): string
    {
        return esc_html__('Image', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['image', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'choose_style',
            [
                'label' => esc_html__('Choose Option', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'description' => esc_html__('Dyname image display by custom post', 'trackngo-core'),
                'default' => 'dynamic',
                'options' => [
                    'static' => esc_html__('Static', 'trackngo-core'),
                    'dynamic' => esc_html__('Dynamic', 'trackngo-core'),
                ],
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => esc_html__('Choose Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'choose_style' => 'static',
                ],
            ]
        );
        $this->add_control(
            'width',
            [
                'label' => esc_html__('Width', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .details-image img' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .details-image' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngo_init = \Trackngo_Elementor_Widget_Init::getInstance();

        // Sub Title style
        $trackngo_init->section_style($this, 'Image', '.details-image img, .details-image');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();

        if ($settings['choose_style'] === 'dynamic') :
            if (has_post_thumbnail()) : ?>
                <div class="details-image">
                    <?php the_post_thumbnail('full'); ?>
                </div>
<?php
            endif;
        endif;

        if ($settings['choose_style'] === 'static') {
            echo wp_get_attachment_image($settings['image']['id'], 'full', false, ['class' => 'details-image']);
        }
    }
}
Plugin::instance()->widgets_manager->register(new Image());
