<?php

namespace Elementor;

class Items_List extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-items-list';
    }

    public function get_title(): string
    {
        return esc_html__('Items List', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['items-list', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'choose_style',
            [
                'label' => esc_html__('Choose Style', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'one' => esc_html__('One', 'trackngo-core'),
                    'two' => esc_html__('two', 'trackngo-core'),
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Service Highlights:', 'trackngo-core'),
                'condition' => [
                    'choose_style' => 'one',
                ],
            ]
        );
        $this->add_control(
            'itmes_list',
            [
                'label' => esc_html__('Repeater List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'list_title',
                        'label' => esc_html__('Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('All-Risk Cargo Insurance', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'list_desc',
                        'label' => esc_html__('Description', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => esc_html__('Full protection against loss, damage, theft, or natural events during transit.', 'trackngo-core'),
                        'label_block' => true,
                        'condition' => [
                            'choose_style' => 'one',
                        ],
                    ],

                    [
                        'name' => 'list_icon',
                        'label' => esc_html__('Icon', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                    ]
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'condition' => [
                    'choose_style' => 'one',
                ],
                'default' => esc_html__('With programs built for all fitness levels, from beginner to athlete, our Fitness & Cardio Strength services empower you to get stronger, feel better, and move with confidence.', 'trackngo-core'),
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Section', '.details-list-item');

        $trackngoElementorInit->typography_style($this, 'Title', '.details-list-item h3');

        $trackngoElementorInit->typography_style($this, 'Items title', '.details-list-item ul li span');

        $trackngoElementorInit->typography_style($this, 'Items Description', '.details-list-item ul li');

        $trackngoElementorInit->typography_style($this, 'Description', '.details-list-item p');

        $this->start_controls_section(
            'icon_style_section',
            [
                'label' => esc_html__('Icon', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'icon_width',
            [
                'label' => esc_html__('Width', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-details-wrapper .details-list-item ul li span i' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-details-wrapper .details-list-item ul li span i' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => esc_html__('Background Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-details-wrapper .details-list-item ul li span i' => 'Background: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'icon_padding',
            [
                'label' => esc_html__('Padding', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-details-wrapper .details-list-item ul li span i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $selected_style = $settings['choose_style'] ? $settings['choose_style'] : 'one';

        if ($selected_style == 'one') :
?>
            <div class="service-details-wrapper">
                <div class="details-list-item">
                    <?php if (!empty($settings['title'])) {
                        echo '<h3>' . esc_html($settings['title']) . '</h3>';
                    } ?>
                    <ul>
                        <?php
                        if (!empty($settings['itmes_list'])):
                            foreach ($settings['itmes_list'] as $item):
                        ?>
                                <li><span><i class="<?php echo esc_attr($item['list_icon']['library'] . ' ' . esc_attr($item['list_icon']['value'])); ?>"></i><?php echo esc_html($item['list_title']); ?></span><?php echo esc_html($item['list_desc']); ?></li>
                        <?php
                            endforeach;
                        endif;
                        ?>
                    </ul>
                    <?php if (!empty($settings['description'])) {
                        echo '<p>' . esc_html($settings['description']) . '</p>';
                    } ?>
                </div>
            </div>

        <?php
        endif;
        if ('two' == $selected_style):
        ?>
            <div class="privacy-wrapper">
                <div class="privacy-list-items">
                    <ul class="mt-0">
                        <?php
                        if (!empty($settings['itmes_list'])):
                            foreach ($settings['itmes_list'] as $item):
                        ?>
                                <li>
                                    <i class="<?php echo esc_attr($item['list_icon']['library'] . ' ' . esc_attr($item['list_icon']['value'])); ?>"></i><span class="color-2"><?php echo esc_html($item['list_title']); ?></span>
                                </li>
                        <?php
                            endforeach;
                        endif;
                        ?>
                    </ul>
                </div>
            </div>
<?php
        endif;
    }
}
Plugin::instance()->widgets_manager->register(new Items_List());
