<?php

namespace Elementor;

class Progress_Bar extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-progress-bar';
    }

    public function get_title(): string
    {
        return esc_html__('Progress Bar', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['progress-bar', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'progress_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Web Development', 'trackngo-core'),
            ]
        );
        $repeater->add_control(
            'progress_percent',
            [
                'label' => esc_html__('Percent', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('90%', 'trackngo-core'),
            ]
        );
        // $repeater->add_control(
		// 	'width',
		// 	[
		// 		'label' => esc_html__( 'Width', 'trackngo-core' ),
		// 		'type' => \Elementor\Controls_Manager::SLIDER,
		// 		'size_units' => ['%'],
		// 		'range' => [
		// 			'%' => [
		// 				'min' => 0,
		// 				'max' => 100,
		// 			],
		// 		],
		// 		'selectors' => [
		// 			'{{WRAPPER}} .load animation' => 'width: {{SIZE}}{{UNIT}};',
		// 		],
		// 	]
		// );
        $this->add_control(
            'list',
            [
                'label' => esc_html__('Progress List List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ progress_title }}}',
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngo_init = \Trackngo_Elementor_Widget_Init::getInstance();

        // Sub Title style
        $trackngo_init->section_style($this, 'Image', '.details-image img, .details-image');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $list = $settings['list'] ? $settings['list'] : [];
?>
        <div class="team-details-wrapper">
            <div class="team-details-content">
                <div class="progress-area mt-4">
                    <div class="progress-wrap">
                        <?php if (!empty($list)) {
                            foreach ($list as $item) {
                        ?>
                                <div class="pro-items">
                                    <div class="pro-head">
                                        <h6 class="title"><?php echo esc_html($item['progress_title']); ?></h6>
                                        <span class="point">
                                            <?php echo esc_html($item['progress_percent']); ?>
                                        </span>
                                    </div>
                                    <div class="progress">
                                        <div class="progress-value" style="width: <?php echo esc_attr($item['progress_percent']); ?> !important;"></div>
                                    </div>
                                </div>
                        <?php
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Progress_Bar());
