<?php

namespace Elementor;

class Project_Info extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-project-info';
    }

    public function get_title(): string
    {
        return esc_html__('Project Info', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['project-info', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            '_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Project Information', 'trackngo-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'info_list',
            [
                'label' => esc_html__('Info List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'list_title',
                        'label' => esc_html__('Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('Client:', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'list_content',
                        'label' => esc_html__('Description', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => esc_html__('Themeforest.Lumextheme', 'trackngo-core'),
                        'show_label' => false,
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );

        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Section', '.project-details-items .project-category');

        $trackngoElementorInit->typography_style($this, 'Title', '.project-category h3');

        $trackngoElementorInit->typography_style($this, 'Info Title', '.project-category ul li');

        $trackngoElementorInit->typography_style($this, 'Info Description', '.project-category ul li span');
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $info_list = $settings['info_list'] ? $settings['info_list'] : [];
?>
        <div class="project-details-items">
            <div class="project-category">
                <?php
                if (!empty($settings['_title'])) {
                    echo '<h3>' . $settings['_title'] . '</h3>';
                }
                ?>
                <ul>
                    <?php if (!empty($info_list)) {
                        foreach ($info_list as $item) {
                            echo '<li>' . $item['list_title'] . ' <span>' . $item['list_content'] . '</span></li>';
                        }
                    } ?>
                </ul>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Project_Info());
