<?php

namespace Elementor;

class Project_Item extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-project-Item';
    }

    public function get_title(): string
    {
        return esc_html__('Project Item', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['project', 'project-item', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'pv1_select',
            [
                'label' => esc_html__('Selece Project', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'default' => '-1',
                'options' => trackngo_get_project(),
            ],
        );
        $this->add_control(
            'project_image',
            [
                'label' => esc_html__('Choose Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ],
        );
        $this->add_control(
            'project_desc',
            [
                'label' => esc_html__('Project Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Specialized delivery of building materials to remote islands with reliable, secur', 'trackngo-core'),
                'label_block' => true,
            ],
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Button Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('VIEW PROJECT', 'trackngo-core'),
                'label_block' => true,
            ],
        );
        $this->add_control(
            'animation_delay',
            [
                'label' => esc_html__('Animation Dealay (MS)', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('400', 'trackngo-core'),
                'label_block' => true,
            ],
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Section Hover', '.project-image-items-3::before');

        $trackngoElementorInit->typography_style($this, 'Title', '.project-image-items-3 h3 a');

        $trackngoElementorInit->typography_style($this, 'Description', '.project-image-items-3 p');

        $trackngoElementorInit->typography_style($this, 'Button Title', '.link-btns');
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $post_id = !empty($settings['pv1_select']) ? intval($settings['pv1_select']) : 0;
        if (!$post_id) {
            return;
        }
        $title = get_the_title($post_id);
        $permalink = get_permalink($post_id);
        $description = $settings['project_desc'];
        $btn_title = $settings['btn_title'];
        $image = !empty($settings['project_image']['id']) ? $settings['project_image']['id'] : '';
?>
        <div class="project-image-items-3 wow animated fadeInUp" data-wow-delay="<?php echo esc_attr($settings['animation_delay']); ?>ms">
            <?php echo wp_get_attachment_image($image, 'full'); ?>
            <div class="project-content">
                <?php if (!empty($title)): ?><h3><a href="<?php echo esc_url($permalink); ?>"><?php echo $title; ?></a></h3><?php endif; ?>

                <?php if (!empty($description)) {
                    echo '<p>' . esc_html($description) . '</p>';
                }; ?>

                <?php if ($btn_title): ?>
                    <a href="<?php echo esc_url($permalink); ?>" class="link-btns">
                        <?php echo esc_html($btn_title); ?>
                        <i class="fa-solid fa-arrow-up-right"></i>
                    </a>
                <?php endif; ?>
            </div>
        </div>

<?php
    }
}
Plugin::instance()->widgets_manager->register(new Project_Item());
