<?php

namespace Elementor;

class Project_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-project-v1';
    }

    public function get_title(): string
    {
        return esc_html__('Section Project V1', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['project', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'project_list',
            [
                'label' => esc_html__('Project List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'pv1_select',
                        'label' => esc_html__('Choose Style', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => 'solid',
                        'options' => trackngo_get_project(),
                    ],
                    [
                        'name' => 'project_image',
                        'label' => esc_html__('Choose Image', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'name' => 'btn_title',
                        'label' => esc_html__('Button Title', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('VIEW PROJECT', 'trackngo-core'),
                        'label_block' => true,
                    ],
                ],
                'title_field' => '{{{ pv1_select.title }}}',
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();
        $trackngoElementorInit->section_style($this, 'Section', '.service-section');
        $trackngoElementorInit->typography_style($this, 'Title', '.project-content h3 a');
        $trackngoElementorInit->typography_style($this, 'Button Title', '.link-btns');
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $project_list = $settings['project_list'];
?>
        <section class="project-section section-padding fix pt-0">
            <div class="project-wrapper">
                <div class="swiper project-slide">
                    <div class="swiper-wrapper">
                        <?php
                        if (!empty($project_list)) :
                            foreach ($project_list as $index => $post) :

                                // Get the project ID from the 'pv3_select' field
                                $post_id = !empty($post['pv1_select']) ? intval($post['pv1_select']) : 0;
                                $title = get_the_title($post_id);
                                $permalink = get_permalink($post_id);
                        ?>
                                <div class="swiper-slide">
                                    <div class="project-box-items">
                                        <div class="project-image">
                                            <?php echo wp_get_attachment_image($post['project_image']['id'], 'full'); ?>
                                            <div class="project-content">
                                                <?php if (!empty($title)): ?><h3><a href="<?php echo esc_url($permalink); ?>"><?php echo $title; ?></a></h3><?php endif; ?>
                                                <?php if ($post['btn_title']): ?>
                                                    <a href="<?php echo esc_url($permalink); ?>" class="link-btns">
                                                        <?php echo esc_html($post['btn_title']); ?>
                                                        <i class="fa-solid fa-arrow-up-right"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        <?php
                            endforeach;
                        endif;
                        ?>

                    </div>
                </div>
            </div>
        </section>

<?php
    }
}
Plugin::instance()->widgets_manager->register(new Project_V1());
