<?php

namespace Elementor;

class Service_Category extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-service-category';
    }

    public function get_title(): string
    {
        return esc_html__('Cervice Category', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['service-category', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('All Categories', 'trackngo-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'items_list',
            [
                'label' => esc_html__('Repeater List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'list_category',
                        'label' => esc_html__('Select Categrry', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => '-1',
                        'options' => service_category(),
                    ],
                ],
                'title_field' => '{{{ list_category.title }}}',
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Section', '.service-details-wrapper .main-sideber .single-sideber-widget');

        $trackngoElementorInit->typography_style($this, 'Title', '.widget-title h3');

        $trackngoElementorInit->typography_style($this, 'Category title', '.category-list li a');

        $trackngoElementorInit->section_style($this, 'Category Body', '.category-list li');

        $trackngoElementorInit->section_style($this, 'Category Body Hover', '.category-list li:hover');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $items_list = $settings['items_list'] ? $settings['items_list'] : [];

?>
        <div class="service-details-wrapper">
            <div class="main-sideber">
                <div class="single-sideber-widget">
                    <?php if (!empty($settings['title'])): ?>
                        <div class="widget-title">
                            <h3><?php echo esc_html($settings['title']); ?></h3>
                        </div>
                    <?php endif; ?>
                    <ul class="category-list">
                        <?php
                        if (!empty($items_list)):
                            foreach ($items_list as $item):
                                $category_id = !empty($item['list_category']) ? intval($item['list_category']) : 0;
                                $category = get_term($category_id);
                                echo '<li><a href="' . esc_url(get_term_link($category)) . '">' . esc_html($category->name) . '</a><span><i class="fa-solid fa-arrow-up-right"></i></span></li>';
                            endforeach;
                        endif;
                        ?>
                    </ul>
                </div>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Service_Category());
