<?php

namespace Elementor;

class Service_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-service-one';
    }

    public function get_title(): string
    {
        return esc_html__('Section Service V1', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['service-one', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title_image_before',
            [
                'label' => esc_html__('Sub Title Before Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'sub-title',
            [
                'label' => esc_html__('Sub Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('OUR SERVICES', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'sub_title_image_after',
            [
                'label' => esc_html__('Sub Title After Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Your Freight, Our Priority.', 'trackngo-core'),
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();

        // Service List Repeater
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('Show Arrow', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'trackngo-core'),
                'label_off' => esc_html__('Hide', 'trackngo-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'sv1_list',
            [
                'label' => esc_html__('Service List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'choose_service',
                        'label' => esc_html__('Choose Service', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => 'solid',
                        'options' => trackngo_get_service(),
                    ],
                    [
                        'name' => 'service_image',
                        'label' => esc_html__('Service Image', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'name' => 'service_icon',
                        'label' => esc_html__('Icon', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                    ],
                ],
                'title_field' => '{{{ choose_service.title }}}',
            ]
        );

        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();
        $trackngoElementorInit->section_style($this, 'Section', '.service-section');
        $trackngoElementorInit->typography_style($this, 'Sub Title', '.IXL-sub-title');
        $trackngoElementorInit->typography_style($this, 'Title', '.IXL-title');
        $trackngoElementorInit->typography_style($this, 'Service Title', '.service-content h3 a');
        $trackngoElementorInit->section_style($this, 'Service Item', '.service-box-items');

        //arrow icon style controls
        $this->start_controls_section(
            'arrow_style_section',
            [
                'label' => esc_html__('Arrow', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'arrow_style_tabs'
        );
        $this->start_controls_tab(
            'arrow_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'arrow_width',
            [
                'label' => esc_html__('Width', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .array-button button i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'arrow_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .array-button button i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_bg_color',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .array-button button' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'arrow_border',
                'selector' => '{{WRAPPER}} .array-button button',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'arrow_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'arrow_color_hover',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .array-button button:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_bg_color_hover',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .array-button button:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'arrow_border_hover',
                'selector' => '{{WRAPPER}} .array-button button:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $service_list = !empty($settings['sv1_list']) ? $settings['sv1_list'] : [];
?>
        <section class="service-section section-padding fix section-bg">
            <?php if (!empty($settings['bg_image']['id'])): ?>
                <div class="service-shape-1">
                    <?php echo wp_get_attachment_image($settings['bg_image']['id'], 'full'); ?>
                </div>
            <?php endif; ?>
            <div class="container">
                <div class="section-title text-center">
                    <?php if (!empty($settings['sub-title'])): ?><h6 class="IXL-sub-title wow fadeInUp"><?php echo wp_get_attachment_image($settings['sub_title_image_before']['id'], 'full'); ?> <?php echo esc_html($settings['sub-title']); ?> <?php echo wp_get_attachment_image($settings['sub_title_image_after']['id'], 'full'); ?><?php endif; ?>
                            <?php if (!empty($settings['title'])): ?><h2 class="IXL-title wow fadeInUp" data-wow-delay=".2s"> <?php echo esc_html($settings['title']); ?></h2><?php endif; ?>
                </div>
                <div class="swiper service-slide">
                    <div class="swiper-wrapper">
                        <?php
                        if (! empty($service_list) && is_array($service_list)) :
                            foreach ($service_list as $index => $item) :
                                $post_id = ! empty($item['choose_service']) ? intval($item['choose_service']) : 0;
                                $service_title = $post_id ? get_the_title($post_id) : '';
                                $service_image = ! empty($item['service_image']['id']) ? $item['service_image']['id'] : \Elementor\Utils::get_placeholder_image_src();
                                $service_link = get_the_permalink($post_id);
                        ?>
                                <div class="swiper-slide">
                                    <div class="service-box-items">
                                        <?php if (!empty($service_image)): ?>
                                            <div class="service-image">
                                                <?php echo wp_get_attachment_image($service_image); ?>
                                            </div>
                                        <?php endif; ?>
                                        <div class="service-content">
                                            <?php if (!empty($item['service_icon'])): ?>
                                                <div class="service-icon">
                                                    <?php \Elementor\Icons_Manager::render_icon($item['service_icon'], ['aria-hidden' => 'true']); ?>
                                                </div>
                                            <?php endif; ?>
                                            <?php if (!empty($service_title)): ?><h3><a href="<?php esc_url($service_link); ?>"><?php echo $service_title; ?></a></h3><?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                        <?php
                            endforeach;
                        endif;
                        ?>
                    </div>

                </div>
                <?php if ('yes' == $settings['show_arrow']): ?>
                    <div class="array-button">
                        <button class="array-prev"><i class="fa-solid fa-arrow-up-left"></i></button>
                        <button class="array-next"><i class="fa-solid fa-arrow-up-right"></i></button>
                    </div>
                <?php endif; ?>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Service_V1());
