<?php

namespace Elementor;

class Service_V3 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-service-three';
    }

    public function get_title(): string
    {
        return esc_html__('Service V3', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['service-three', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_service',
            [
                'label' => esc_html__('Select Service', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '-1',
                'options' => trackngo_get_service(),

            ]
        );
        $this->add_control(
            'service_image',
            [
                'label' => esc_html__('Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'service_icon',
            [
                'label' => esc_html__('Icon', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'service_content',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => esc_html__('Efficient cargo transfer between major international hubs.', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'animation_delay',
            [
                'label' => esc_html__('Animation Delay (MS)', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'rows' => 10,
                'default' => esc_html__('400', 'trackngo-core'),
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();
        $trackngoElementorInit->section_style($this, 'Service Item ', '.service-box-items-3');
        $trackngoElementorInit->typography_style($this, 'Title', '.service-content h3 a');
        $trackngoElementorInit->typography_style($this, 'Description', '.service-content p');
        $trackngoElementorInit->section_style($this, 'Icon Body', '.service-image .icon');
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $select_service_id = $settings['select_service'] ? intval($settings['select_service']) : 0;
        $title = get_the_title($select_service_id);
        $permalink = get_the_permalink($select_service_id);
?>
        <div class="service-box-items-3 wow fadeInUp" data-wow-delay="<?php echo esc_attr($settings['animation_delay']); ?>ms">
            <div class="service-content">
                <?php if (!empty($title)): ?><h3><a href="<?php echo esc_url($permalink); ?>"><?php echo esc_html($title); ?></a></h3><?php endif; ?>
                <?php if (!empty($settings['service_content'])): ?><p><?php echo esc_html($settings['service_content']); ?></p><?php endif; ?>
            </div>
            <div class="service-image">
                <?php echo wp_get_attachment_image($settings['service_image']['id'], 'full'); ?>
                <?php if (!empty($settings['service_icon']['id'])): ?>
                    <div class="icon">
                        <?php echo wp_get_attachment_image($settings['service_icon']['id'], 'full'); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Service_V3());
