<?php

namespace Elementor;

class Social_Icon extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-social-icon';
    }

    public function get_title(): string
    {
        return esc_html__('Social Icon', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['social-icon', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'choose_style',
            [
                'label' => esc_html__('Choose Style', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'one',
                'options' => [
                    'one' => esc_html__('One', 'trackngo-core'),
                    'two' => esc_html__('Two', 'trackngo-core'),
                ],
            ]
        );
        $this->add_control(
            '_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Social Icon', 'trackngo-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'icon_list',
            [
                'label' => esc_html__('Icon List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'list_icon',
                        'label' => esc_html__('Icon', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                    ],
                    [
                        'name' => 'list_link',
                        'label' => esc_html__('Link', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ list_icon.title }}}',
            ]
        );

        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();

        $trackngoElementorInit->section_style($this, 'Section', '.project-details-items .social-list, .team-details-wrapper');

        $trackngoElementorInit->typography_style($this, 'Title', '.social-list h3, .social-icon span');


        // Social Icon Style
        $this->start_controls_section(
            'icon_style_section',
            [
                'label' => esc_html__('Social Icon', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'icon_style_tabs'
        );
        $this->start_controls_tab(
            'icon_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_width',
            [
                'label' => esc_html__('Width', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .project-details-items .social-list .social-icon a i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .social-icon a i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-details-items .social-list .social-icon a i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .social-icon a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-details-items .social-list .social-icon a' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .social-icon a' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .project-details-items .social-list .social-icon a , {{WRAPPER}} .social-icon a',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'icon_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-details-items .social-list .social-icon a:hover i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .social-icon a:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color_hover',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-details-items .social-list .social-icon a:hover' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .social-icon a:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border_hover',
                'selector' => '{{WRAPPER}} .project-details-items .social-list .social-icon a:hover, {{WRAPPER}} .social-icon a:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $icon_list = $settings['icon_list'] ? $settings['icon_list'] : [];
        $choose_style = $settings['choose_style'];

        if ($choose_style === 'one') :
?>
            <div class="project-details-items">
                <div class="social-list">
                    <?php
                    if (!empty($settings['_title'])) {
                        echo '<h3>' . $settings['_title'] . '</h3>';
                    }
                    ?>
                    <div class="social-icon d-flex align-items-center">
                        <?php
                        if (!empty($icon_list)) {
                            foreach ($icon_list as $item) {
                                echo '<a href="' . esc_url($item['list_link']['url']) . '" ' . ($item['list_link']['is_external'] ? 'target="_blank"' : '') . ' ' . ($item['list_link']['nofollow'] ? 'rel="nofollow"' : '') . '><i class="' . esc_attr($item['list_icon']['library']) . ' ' . esc_attr($item['list_icon']['value']) . '"></i></a>';
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>

        <?php endif;
        if ('two' == $choose_style): ?>
            <div class="team-details-wrapper">
                <div class="team-details-content">
                    <div class="social-icon">
                        <?php
                        if (!empty($settings['_title'])) {
                            echo '<span>' . $settings['_title'] . '</span>';
                        }
                        ?>
                        <?php
                        if (!empty($icon_list)) {
                            foreach ($icon_list as $item) {
                                echo '<a href="' . esc_url($item['list_link']['url']) . '" ' . ($item['list_link']['is_external'] ? 'target="_blank"' : '') . ' ' . ($item['list_link']['nofollow'] ? 'rel="nofollow"' : '') . '><i class="' . esc_attr($item['list_icon']['library']) . ' ' . esc_attr($item['list_icon']['value']) . '"></i></a>';
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>
<?php
        endif;
    }
}
Plugin::instance()->widgets_manager->register(new Social_Icon());
