<?php

namespace Elementor;

class Section_Testimonal_V2 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-testimonial-v2';
    }

    public function get_title(): string
    {
        return esc_html__('Testimonal V2', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['testimonial', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section_title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title_image_before',
            [
                'label' => esc_html__('Sub Title Before Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('OUR SERVICES', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'sub_title_image_after',
            [
                'label' => esc_html__('Sub Title After Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Your Freight, Our Priority.', 'trackngo-core'),
            ]
        );
        $this->end_controls_section();


        // testimonial content repeater
        $this->start_controls_section(
            'testimoanial_content_section',
            [
                'label' => esc_html__('Testimonial', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'right_shape_image',
            [
                'label' => esc_html__('Right Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'testimonial_list',
            [
                'label' => esc_html__('Testimonial List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'name',
                        'label' => esc_html__('Name', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Marvin McKinney', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'profession',
                        'label' => esc_html__('Profession', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Lead Developer', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'description',
                        'label' => esc_html__('Description', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => esc_html__('Luctus dignissim ornare suscipt penatibus suspendisse faciliy placera eleifend duise quam enimes egeter platea consectetuer malesuada an hack blandit proin suscipit porta vitae enter an ultricies tempor ultrices duisentis a auctor tempor neque cubilia psum risus commodo pulvina aliquam donec arcu.', 'trackngo-core'),
                        'show_label' => false,
                    ],
                    [
                        'name' => 'rating',
                        'label' => esc_html__('Rating', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => 'five',
                        'options' => [
                            'one' => esc_html__('One Star', 'trackngo-core'),
                            'two' => esc_html__('Two Star', 'trackngo-core'),
                            'three' => esc_html__('Three Star', 'trackngo-core'),
                            'four' => esc_html__('Four Star', 'trackngo-core'),
                            'five' => esc_html__('Five Star', 'trackngo-core'),
                        ],
                    ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );
        $this->end_controls_section();


        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();
        $trackngoElementorInit->section_style($this, 'Section', '.testimonial-section-2');
        $trackngoElementorInit->typography_style($this, 'Sub Title', '.IXL-sub-title');
        $trackngoElementorInit->typography_style($this, 'Title', '.IXL-title');
        $trackngoElementorInit->typography_style($this, 'Name', '.client-info h3');
        $trackngoElementorInit->typography_style($this, 'Profession', '.client-info p');
        $trackngoElementorInit->typography_style($this, 'Description', '.testimonial-desc');
        $trackngoElementorInit->section_style($this, 'Slider & Left Shape', '.testimonial-section-2 .testimonial-wrapper-2 .testimonial-left-items .testimonial-content-box-2');

        //arrow icon style controls
        $this->start_controls_section(
            'arrow_style_section',
            [
                'label' => esc_html__('Arrow', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'arrow_style_tabs'
        );
        $this->start_controls_tab(
            'arrow_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'arrow_width',
            [
                'label' => esc_html__('Width', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .array-button button i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'arrow_color',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .array-button button i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_bg_color',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .array-button button' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'arrow_border',
                'selector' => '{{WRAPPER}} .array-button button',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'arrow_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'arrow_color_hover',
            [
                'label' => esc_html__('Color', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .array-button button:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_bg_color_hover',
            [
                'label' => esc_html__('Background', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .array-button button:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'arrow_border_hover',
                'selector' => '{{WRAPPER}} .array-button button:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $testimonial_list = isset($settings['testimonial_list']) ? $settings['testimonial_list'] : [];
?>

        <section class="testimonial-section-2 section-padding fix section-bg">
            <div class="container">
                <div class="testimonial-wrapper-2">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="testimonial-left-items">
                                <div class="section-title mb-0">
                                    <?php if (!empty($settings['sub_title'])): ?><h6 class="IXL-sub-title wow fadeInUp"><?php echo wp_get_attachment_image($settings['sub_title_image_before']['id'], 'full'); ?> <?php echo esc_html($settings['sub_title']); ?> <?php echo wp_get_attachment_image($settings['sub_title_image_after']['id'], 'full'); ?></h6><?php endif; ?>
                                    <?php if (!empty($settings['title'])): ?><h2 class="IXL-title wow fadeInUp" data-wow-delay=".2s"> <?php echo esc_html($settings['title']); ?></h2><?php endif; ?>
                                    <div class="swiper testimonial-content-slide">
                                        <div class="swiper-wrapper">
                                            <?php
                                            if (!empty($testimonial_list)):
                                                foreach ($testimonial_list as $item): ?>
                                                    <div class="swiper-slide">
                                                        <div class="testimonial-content-box-2">
                                                            <div class="star wow fadeInUp" data-wow-delay=".3s">
                                                                <?php
                                                                if ($item['rating'] == 'one') {
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                } elseif ($item['rating'] == 'two') {
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                } elseif ($item['rating'] == 'three') {
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                } elseif ($item['rating'] == 'four') {
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                } else {
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                    echo '<i class="fa-solid fa-star-sharp"></i>';
                                                                }
                                                                ?>
                                                            </div>
                                                            <?php if (!empty($item['description'])): ?><h4 class="wow fadeInUp testimonial-desc" data-wow-delay=".5s"><?php echo esc_html($item['description']); ?></h4><?php endif; ?>
                                                            <div class="client-info wow fadeInUp" data-wow-delay=".7s">
                                                                <?php if (!empty($item['name'])): ?><h3><?php echo esc_html($item['name']); ?></h3><?php endif; ?>
                                                                <?php if (!empty($item['profession'])): ?><p><?php echo esc_html($item['profession']); ?></p><?php endif; ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                            <?php
                                                endforeach;
                                            endif;
                                            ?>
                                        </div>
                                        <div class="array-button">
                                            <button class="array-prev"><i class="fa-solid fa-arrow-up-left"></i></button>
                                            <button class="array-next"><i class="fa-solid fa-arrow-up-right"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php if (!empty($settings['right_shape_image']['id'])): ?>
                            <div class="col-lg-6 wow fadeInUp" data-wow-delay=".3s">
                                <div class="testimonial-image">
                                    <?php echo wp_get_attachment_image($settings['right_shape_image']['id'], 'full'); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Section_Testimonal_V2());
