<?php

namespace Elementor;

class Section_Testimonal_V3 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-testimonial-v3';
    }

    public function get_title(): string
    {
        return esc_html__('Testimonal V3', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['testimonial', 'testimonial-v2', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section_',
            [
                'label' => esc_html__('Section', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_img',
            [
                'label' => esc_html__('Background Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape_img',
            [
                'label' => esc_html__('Shape Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();


        // testimonial content repeater
        $this->start_controls_section(
            'testimoanial_content_section',
            [
                'label' => esc_html__('Testimonial', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'testimonial_list',
            [
                'label' => esc_html__('Testimonial List', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'profile_img',
                        'label' => esc_html__('Profile Image', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'name' => 'name',
                        'label' => esc_html__('Name', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Marvin McKinney', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'profession',
                        'label' => esc_html__('Profession', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Lead Developer', 'trackngo-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'description',
                        'label' => esc_html__('Description', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => esc_html__('Luctus dignissim ornare suscipt penatibus suspendisse faciliy placera eleifend duise quam enimes egeter platea consectetuer malesuada an hack blandit proin suscipit porta vitae enter an ultricies tempor ultrices duisentis a auctor tempor neque cubilia psum risus commodo pulvina aliquam donec arcu.', 'trackngo-core'),
                        'show_label' => false,
                    ],
                    [
                        'name' => 'rating',
                        'label' => esc_html__('Rating', 'trackngo-core'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => 'five',
                        'options' => [
                            'one' => esc_html__('One Star', 'trackngo-core'),
                            'two' => esc_html__('Two Star', 'trackngo-core'),
                            'three' => esc_html__('Three Star', 'trackngo-core'),
                            'four' => esc_html__('Four Star', 'trackngo-core'),
                            'five' => esc_html__('Five Star', 'trackngo-core'),
                        ],
                    ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );
        $this->end_controls_section();


        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();
        $trackngoElementorInit->section_style($this, 'Section', '.testimonial-section-3');
        $trackngoElementorInit->typography_style($this, 'Name', '.client-info h3');
        $trackngoElementorInit->typography_style($this, 'Profession', '.client-info p');
        $trackngoElementorInit->typography_style($this, 'Description', '.testimonial-desc');
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $testimonial_list = isset($settings['testimonial_list']) ? $settings['testimonial_list'] : [];
?>
        <section class="testimonial-section-3 section-padding pt-0 fix bg-cover" style="background-image: url('<?php echo esc_url($settings['bg_img']['url']); ?>');">
            <?php if (!empty($settings['shape_img']['id'])): ?>
                <div class="testimonial-shape-1">
                    <?php echo wp_get_attachment_image($settings['shape_img']['id']); ?>
                </div>
            <?php endif; ?>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="swiper testimonial-content-slide">
                            <div class="swiper-wrapper">
                                <?php
                                if (!empty($testimonial_list)):
                                    foreach ($testimonial_list as $item): ?>
                                        <div class="swiper-slide">
                                            <div class="testimonial-box-item-3">
                                                <div class="star wow fadeInUp">
                                                    <?php
                                                    if ($item['rating'] == 'one') {
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                    } elseif ($item['rating'] == 'two') {
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                    } elseif ($item['rating'] == 'three') {
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                    } elseif ($item['rating'] == 'four') {
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                    } else {
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                        echo '<i class="fa-solid fa-star-sharp"></i>';
                                                    }
                                                    ?>
                                                </div>
                                                <?php if (!empty($item['description'])): ?><h4 class="wow fadeInUp testimonial-desc" data-wow-delay=".5s"><?php echo esc_html($item['description']); ?></h4><?php endif; ?>
                                                <div class="client-info wow fadeInUp" data-wow-delay=".7s">
                                                    <div class="client-info wow fadeInUp" data-wow-delay=".3s">
                                                        <?php if (!empty($item['profile_img']['id'])): ?>
                                                            <div class="image">
                                                                <?php echo wp_get_attachment_image($item['profile_img']['id'], 'full'); ?>
                                                            </div>
                                                        <?php endif; ?>
                                                        <?php if (!empty($item['name'])): ?><h3><?php echo esc_html($item['name']); ?></h3><?php endif; ?>
                                                        <?php if (!empty($item['profession'])): ?><p><?php echo esc_html($item['profession']); ?></p><?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                <?php
                                    endforeach;
                                endif;
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Section_Testimonal_V3());
