<?php

namespace Elementor;

class Work_Process extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-work-process';
    }

    public function get_title(): string
    {
        return esc_html__('Work Process', 'trackngo-core');
    }

    public function get_icon(): string
    {
        return 'trackngo-custom-icon';
    }

    public function get_categories(): array
    {
        return ['trackngo_widgets'];
    }

    public function get_keywords(): array
    {
        return ['work-process', 'trackngo'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'trackngo-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'icon_image',
            [
                'label' => esc_html__('Icon Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape_image',
            [
                'label' => esc_html__('Shape Image', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'step_title',
            [
                'label' => esc_html__('Step Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('STEP - 01', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'main_title',
            [
                'label' => esc_html__('Main Title', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Request & Booking', 'trackngo-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'trackngo-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Customers submit shipment details and  receive a tailored quote. ', 'trackngo-core'),
            ]
        );
        $this->end_controls_section();

        // Trackngo_Elementor_Widget_Init instance
        $trackngoElementorInit = \Trackngo_Elementor_Widget_Init::getInstance();
        $trackngoElementorInit->section_style($this, 'Section', '.work-process-box-items');
        $trackngoElementorInit->typography_style($this, 'Step Title', '.content h4');
        $trackngoElementorInit->typography_style($this, 'Main Title', '.content h3');
        $trackngoElementorInit->typography_style($this, 'Description', '.content p');
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
?>

        <div class="work-process-box-items fadeInUp wow animated" data-wow-delay="400ms">
            <?php if (!empty($settings['shape_image']['id'])): ?>
                <div class="shape">
                    <?php echo wp_get_attachment_image($settings['shape_image']['id'], 'full'); ?>
                </div>
            <?php endif; ?>
            <?php if (!empty($settings['icon_image']['id'])): ?>
                <div class="icon">
                    <?php echo wp_get_attachment_image($settings['icon_image']['id'], 'full'); ?>
                </div>
            <?php endif; ?>
            <div class="content">
                <?php if (!empty($settings['step_title'])): ?><h4><?php echo esc_html($settings['step_title']); ?></h4><?php endif; ?>
                <?php if (!empty($settings['main_title'])): ?><h3><?php echo esc_html($settings['main_title']); ?></h3><?php endif; ?>
                <?php if (!empty($settings['description'])): ?><p class="px-0 px-sm-3"><?php echo esc_html($settings['description']); ?></p><?php endif; ?>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Work_Process());
