<?php

/*===== Post Type: header footer builder. =====*/
if (!function_exists('trackngo_core_register_header_and_footer')) {
	function trackngo_core_register_header_and_footer()
	{
		register_post_type(
			'trackngo_hf',
			array(
				'labels' => array(
					'name' => __('Headers & Footers', 'trackngo-core'),
					'singular_name' => __('Header & Footer', 'trackngo-core'),
				),
				'public' => true,
				'rewrite' => array('slug' => 'header_footer'),
				'publicly_queryable' => true,
				'show_in_menu'      => true,
				'menu_position' => 31,
				'can_export' => true,
				'menu_icon' => 'dashicons-align-wide',
				'supports' => ['title', 'elementor']
			)
		);
	}
	add_action('init', 'trackngo_core_register_header_and_footer');
}

/*===== Post Type: trackngo_team =====*/
if (!function_exists('trackngo_core_register_team')) {
	function trackngo_core_register_team()
	{
		$labels = [
			"name" => esc_html__("Team", "trackngo"),
			"singular_name" => esc_html__("team", "trackngo"),
			'add_new'               => __('Add Team', 'trackngo-core'),
			'add_new_item'          => __('Add Team', 'trackngo-core'),
		];

		$args = [
			"label" => esc_html__("Team", "trackngo"),
			"labels" => $labels,
			"description" => "",
			"public" => true,
			"publicly_queryable" => true,
			"show_ui" => true,
			"show_in_rest" => true,
			"rest_base" => "",
			"rest_controller_class" => "WP_REST_Posts_Controller",
			"rest_namespace" => "wp/v2",
			"has_archive" => false,
			"show_in_menu" => true,
			"show_in_nav_menus" => true,
			"delete_with_user" => false,
			"exclude_from_search" => false,
			"capability_type" => "post",
			"map_meta_cap" => true,
			"hierarchical" => false,
			"can_export" => true,
			"rewrite" => ["slug" => "trackngo_team", "with_front" => true],
			"query_var" => true,
			"menu_position" => 31,
			"menu_icon" => "dashicons-sticky",
			"supports" => ["title", "thumbnail", "elementor"],
			"show_in_graphql" => false,
		];

		register_post_type("trackngo_team", $args);
	}
	add_action('init', 'trackngo_core_register_team');
}

/*===== Post Type: trackngo_service  =====*/
if (!function_exists('trackngo_core_register_services')) {
	function trackngo_core_register_services()
	{
		$labels = [
			"name" => esc_html__("Services", "trackngo"),
			"singular_name" => esc_html__("service", "trackngo"),
			'add_new'               => __('Add Service', 'trackngo-core'),
			'add_new_item'          => __('Add Service', 'trackngo-core'),
		];

		$args = [
			"label" => esc_html__("Services", "trackngo"),
			"labels" => $labels,
			"description" => "",
			"public" => true,
			"publicly_queryable" => true,
			"show_ui" => true,
			"show_in_rest" => true,
			"rest_base" => "",
			"rest_controller_class" => "WP_REST_Posts_Controller",
			"rest_namespace" => "wp/v2",
			"has_archive" => false,
			"show_in_menu" => true,
			"show_in_nav_menus" => true,
			"delete_with_user" => false,
			"exclude_from_search" => false,
			"capability_type" => "post",
			"map_meta_cap" => true,
			"hierarchical" => false,
			"can_export" => true,
			"rewrite" => ["slug" => "trackngo_service", "with_front" => true],
			"query_var" => true,
			"menu_position" => 31,
			"menu_icon" => "dashicons-sticky",
			"supports" => ["title", "thumbnail", "elementor"],
			"show_in_graphql" => false,
		];

		register_post_type("trackngo_service", $args);
	}
	add_action('init', 'trackngo_core_register_services');
}

/*===== Post Type: trackngo_project =====*/
if (!function_exists('trackngo_core_register_project')) {
	function trackngo_core_register_project()
	{
		$labels = [
			"name" => esc_html__("Projects", "trackngo"),
			"singular_name" => esc_html__("project", "trackngo"),
			'add_new'               => __('Add Project', 'trackngo-core'),
			'add_new_item'          => __('Add Project', 'trackngo-core'),
		];

		$args = [
			"label" => esc_html__("Projects", "trackngo"),
			"labels" => $labels,
			"description" => "",
			"public" => true,
			"publicly_queryable" => true,
			"show_ui" => true,
			"show_in_rest" => true,
			"rest_base" => "",
			"rest_controller_class" => "WP_REST_Posts_Controller",
			"rest_namespace" => "wp/v2",
			"has_archive" => false,
			"show_in_menu" => true,
			"show_in_nav_menus" => true,
			"delete_with_user" => false,
			"exclude_from_search" => false,
			"capability_type" => "post",
			"map_meta_cap" => true,
			"hierarchical" => false,
			"can_export" => true,
			"rewrite" => ["slug" => "trackngo_project", "with_front" => true],
			"query_var" => true,
			"menu_position" => 31,
			"menu_icon" => "dashicons-sticky",
			"supports" => ["title", "thumbnail", "elementor"],
			"show_in_graphql" => false,
		];

		register_post_type("trackngo_project", $args);
	}
	add_action('init', 'trackngo_core_register_project');
}


/*===== Taxonomy: Service Categories.=====*/
function trackngo_service_category()
{

	$args = [
		"label" => esc_html__("Categories", "trackngo"),
		"labels" => [
			"name" => esc_html__("Categories", "trackngo"),
			"singular_name" => esc_html__("Category", "trackngo"),
		],
		"public" => true,
		"publicly_queryable" => true,
		"hierarchical" => true,
		"show_ui" => true,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"query_var" => true,
		"rewrite" => ['slug' => 'service_category', 'with_front' => true,],
		"show_admin_column" => false,
		"show_in_rest" => true,
		"show_tagcloud" => false,
		"can_export" => true,
		"rest_base" => "service_category",
		"rest_controller_class" => "WP_REST_Terms_Controller",
		"rest_namespace" => "wp/v2",
		"show_in_quick_edit" => false,
		"sort" => false,
		"show_in_graphql" => false,
	];
	register_taxonomy("service_category", ["trackngo_service"], $args);
}
add_action('init', 'trackngo_service_category');
