<?php
/*===== Header option to theme option-> header =====*/
if (!function_exists('trackngo_header_styles')) {
    function trackngo_header_styles()
    {
        $trackngo_header = ['' => esc_html__('Default', 'trackngo-core')];
        $trackngo_headers = get_posts(
            [
                'post_type' => 'trackngo_hf',
                'posts_per_page' => -1,
                'orderby' => 'name',
                'order' => 'ASC',
                'meta_query' => array(
                    array(
                        'key' => 'choose-header-footer-opt',
                        'value' => 'header_key',
                        'compare' => '='
                    )
                )
            ]
        );
        foreach ($trackngo_headers as $value) {
            $trackngo_header[$value->ID] = $value->post_title;
        }
        return $trackngo_header;
    };
}

/*===== Footer option to theme option-> footer =====*/
if (!function_exists('trackngo_footer_styles')) {
    function trackngo_footer_styles()
    {
        $trackngo_footer = ['' => esc_html__('Default', 'trackngo-core')];
        $trackngo_footers = get_posts(
            [
                'post_type' => 'trackngo_hf',
                'posts_per_page' => -1,
                'orderby' => 'name',
                'order' => 'ASC',
                'meta_query' => array(
                    array(
                        'key' => 'choose-header-footer-opt',
                        'value' => 'footer_key',
                        'compare' => '='
                    )
                )
            ]
        );
        foreach ($trackngo_footers as $value) {
            $trackngo_footer[$value->ID] = $value->post_title;
        }
        return $trackngo_footer;
    };
};

/*===== Post share function =====*/
if (!function_exists('trackngo_post_share')) {
    function trackngo_post_share()
    {

        $post_title   = htmlspecialchars(urlencode(html_entity_decode(esc_attr(get_the_title()), ENT_COMPAT, 'UTF-8')), ENT_COMPAT, 'UTF-8');
        $post_id    = get_the_ID();
        $post_url   = get_permalink($post_id);
?>
        <span class="share-title me-3"><?php esc_html_e('Share:', 'trackngo-core'); ?></span>
        <ul class="social-share-icons list-unstyled d-flex align-items-center justify-content-center justify-content-md-end gap-2 mb-0">
            <li>
                <a href="https://www.facebook.com/sharer.php?u=<?php echo rawurlencode(esc_url($post_url)); ?>" rel="external" target="_blank" class="fb-share">
                    <i class="fa-brands fa-facebook-f"></i>
                </a>
            </li>

            <li>
                <a href="https://twitter.com/share?text=<?php echo wp_strip_all_tags($post_title); ?>&amp;url=<?php echo rawurlencode(esc_url($post_url)); ?>" rel="external" target="_blank" class="twitter-share">
                    <i class="fa-brands fa-twitter"></i>
                </a>
            </li>

            <li>
                <a href="https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo rawurlencode(esc_url($post_url)); ?>&amp;title=<?php echo wp_strip_all_tags($post_title); ?>&amp;summary=<?php echo urlencode(wp_trim_words(strip_shortcodes(get_the_content($post_id)), 40)); ?>&amp;source=<?php echo esc_url(home_url('/')); ?>" rel="external" target="_blank" class="linkedin-share">
                    <i class="fa-brands fa-linkedin-in"></i>
                </a>
            </li>

            <li>
                <a href="https://www.pinterest.com/pin/create/button/?url=<?php echo rawurlencode(esc_url($post_url)); ?>&amp;media=<?php echo wp_get_attachment_url(get_post_thumbnail_id($post_id)); ?>&amp;description=<?php echo urlencode(wp_trim_words(strip_shortcodes(get_the_content($post_id)), 40)); ?>" rel="external" target="_blank" class="pinterest-share">
                    <i class="fa-brands fa-pinterest"></i>
                </a>
            </li>
        </ul>
<?php
    }
}

/*===== reading time =====*/
if (!function_exists('trackngo_reading_time')) {
    function trackngo_reading_time()
    {
        $content = get_post_field('post_content', get_the_ID());
        $word_count = str_word_count(strip_tags($content));
        $readingtime = ceil($word_count / 200);
        $totalreadingtime = $readingtime . ' ' . esc_html__('Min Read', 'trackngo');
        echo esc_html($totalreadingtime);
    }
}


/*===== Get services post =====*/
if (!function_exists('trackngo_get_service')) {
    function trackngo_get_service()
    {
        $get_posts = get_posts(array(
            'post_type' => 'trackngo_service',
            'numberposts' => -1,
        ));
        $options = [];
        foreach ($get_posts as $post) {
            $options[$post->ID] = get_the_title($post->ID);
        }
        return $options;
    }
}

/*===== Get project post =====*/
if (!function_exists('trackngo_get_project')) {
    function trackngo_get_project()
    {
        $get_posts = get_posts(array(
            'post_type' => 'trackngo_project',
            'numberposts' => -1,
        ));
        $options = [];
        foreach ($get_posts as $post) {
            $options[$post->ID] = get_the_title($post->ID);
        }
        return $options;
    }
}


/*===== Get team post =====*/
if (!function_exists('trackngo_get_team')) {
    function trackngo_get_team()
    {
        $get_posts = get_posts(array(
            'post_type' => 'trackngo_team',
            'numberposts' => -1,
        ));
        $options = [];
        foreach ($get_posts as $post) {
            $options[$post->ID] = get_the_title($post->ID);
        }
        return $options;
    }
}


/*===== Get blog post =====*/
if (!function_exists('trackngo_get_blog')) {
    function trackngo_get_blog()
    {
        $get_posts = get_posts(array(
            'post_type' => 'post',
            'numberposts' => -1,
        ));
        $options = [];
        foreach ($get_posts as $post) {
            $options[$post->ID] = get_the_title($post->ID);
        }
        return $options;
    }
}


/*===== Post Type: Service Category =====*/
if (!function_exists('service_category')) {
    function service_category()
    {
        $categories = get_terms(
            array(
                'taxonomy' => 'service_category',
                'hide_empty' => false,
            )
        );

        $options = [];
        if (!empty($categories) && !is_wp_error($categories)) {
            foreach ($categories as $category) {
                $options[$category->term_id] = $category->name;
            }
        }
        return $options;
    }
}

/*===== Menu selector =====*/
if (!function_exists('service_trackngo_menu_selectorcategory')) {
    function trackngo_menu_selector()
    {
        $menus = wp_get_nav_menus();
        $items = array();
        $i     = 0;
        foreach ($menus as $menu) {
            if ($i == 0) {
                $default = $menu->slug;
                $i++;
            }
            $items[$menu->slug] = $menu->name;
        }
        return $items;
    }
}
