<?php
// Create a section
CSF::createSection($prefix, array(
    'id'     => 'blog-page-opt',
    'title'  => esc_html__('Blog Page', 'trackngo-core'),
    'icon'   => 'fa fa-building',
));

CSF::createSection($prefix, array(
    'parent' => 'blog-page-opt',
    'id'     => 'blog-page-info-opt',
    'icon'  => 'fa fa-pencil-square',
    'title'  => esc_html__('Blog Page', 'trackngo-core'),
    'fields' => array(
        array(
            'id'          => 'blog-layout-opt',
            'type'        => 'select',
            'title'       => esc_html__('Blog layout', 'trackngo-core'),
            'options'     => array(
                'grid-full'  => esc_html__('Grid Full', 'trackngo-core'),
                'standard'  => esc_html__('Standard', 'trackngo-core'),
            ),
            'default'     => 'standard',
        ),
        array(
            'id'    => 'read-more-switcher',
            'type'  => 'switcher',
            'title' => esc_html__('Enable Button', 'trackngo-core'),
        ),
        array(
            'id'      => 'read-more-text',
            'type'    => 'text',
            'title'   => 'Text',
            'title' => esc_html__('Read More Text', 'trackngo-core'),
            'default' => 'Continue Reading',
            'dependency' => array('read-more-switcher', '==', 'true'),
        ),
    )
));

//metadata info
CSF::createSection($prefix, array(
    'parent' => 'blog-page-opt',
    'title'  => esc_html__('Meta Info', 'trackngo-core'),
    'icon'  => 'fa fa-th',
    'fields' => array(
        array(
            'id'    => 'post-date-switcher',
            'type'  => 'switcher',
            'title' => esc_html__('Post Date', 'trackngo-core'),
            'default' => true,
        ),
        array(
            'id'    => 'post-author-switcher',
            'type'  => 'switcher',
            'title' => esc_html__('Post Author', 'trackngo-core'),
            'default' => true,
        ),
        array(
            'id'    => 'post-comments-switcher',
            'type'  => 'switcher',
            'title' => esc_html__('Post Comments', 'trackngo-core'),
            'default' => true,
        ),
    )
));
