<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/*===== Create theme options =====*/
if (class_exists('CSF')) {
    $prefix = 'trackngo_csf';
    CSF::createOptions($prefix, array(
        'framework_title' => wp_kses(sprintf(__('Trackngo Options <small>v%s</small>', 'trackngo-core'), TRACKNGO_CORE_VERSION), array('small' => array())),
        'menu_title'      => __('Theme Options', 'trackngo-core'),
        'menu_slug'       => 'trackngo-options',
        'enqueue_webfont'    => true,
        'show_in_customizer' => true,
        'menu_icon' => 'dashicons-category',
        'show_sub_menu'   => false,
        'class'           => 'trackngo-theme-option',
        'menu_position'   => 1,
        'footer_text'   => wp_kses(
            __('Developed by: <a target="_blank" href="https://inventxlab.com">Inventxlab</a>', 'trackngo-core'),
            array(
                'a'  => array(
                    'href'   => array(),
                    'target' => array()
                ),
            )
        ),
        'async_webfont' => false,
    ));
}
