<?php

// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a metabox for post format gallery
    $clinfyx_gallery_post_format = 'trackngo_post_gallery_metabox';
    CSF::createMetabox($clinfyx_gallery_post_format, array(
        'title'     => esc_html__('Gallery Post Format Option', 'trackngo-core'),
        'post_type' => array('post'),
        'post_formats' => array('gallery'),
    ));
    CSF::createSection($clinfyx_gallery_post_format, array(
        // 'title'  => esc_html__('Gallery', 'trackngo-core'),
        'fields' => array(
            array(
                'id'          => 'post_gallery',
                'type'        => 'gallery',
                'title'       => esc_html__('Gallery', 'trackngo-core'),
                'add_title'   => esc_html__('Add Images', 'trackngo-core'),
                'edit_title'  => esc_html__('Edit Images', 'trackngo-core'),
                'clear_title' => esc_html__('Remove Images', 'trackngo-core'),
                'desc'        => esc_html__('Upload or add images to the gallery.', 'trackngo-core'),
            ),
        )
    ));

    // Create a metabox for post format video
    $clinfyx_video_post_format = 'trackngo_post_video_metabox';
    CSF::createMetabox($clinfyx_video_post_format, array(
        'title'     => esc_html__('Video Post Format Option', 'trackngo-core'),
        'post_type' => array('post'),
        'post_formats' => array('video'),
    ));
    CSF::createSection($clinfyx_video_post_format, array(
        // 'title'  => esc_html__('Video', 'trackngo-core'),
        'fields' => array(
            array(
                'id'      => 'post-video',
                'type'    => 'text',
                'title'   => esc_html__('Video URL', 'trackngo-core'),
                'desc'    => esc_html__('Paste your video Url', 'trackngo-core'),
                'default' => 'https://www.youtube.com/watch?v=7e90gBu4pas',
            ),
        )
    ));


    // Create a metabox for post format audio
    $clinfyx_audio_post_format = 'trackngo_post_audio_metabox';
    CSF::createMetabox($clinfyx_audio_post_format, array(
        'title'     => esc_html__('Audio Post Format Option', 'trackngo-core'),
        'post_type' => array('post'),
        'post_formats' => array('audio'),
    ));
    CSF::createSection($clinfyx_audio_post_format, array(
        // 'title'  => esc_html__('Audio', 'trackngo-core'),
        'fields' => array(
            array(
                'id'      => 'post-audio',
                'type'  => 'code_editor',
                'settings' => array(
                    'theme'  => 'monokai',
                    'mode'   => 'htmlmixed',
                ),
                'title'   => esc_html__('Audio URL', 'trackngo-core'),
                'desc'    => esc_html__('Paste sound cloud audio embed code here', 'trackngo-core'),
                'default' => '',
            ),
        )
    ));



    // Create a metabox for post format link
    $clinfyx_link_post_format = 'trackngo_post_link_metabox';
    CSF::createMetabox($clinfyx_link_post_format, array(
        'title'     => esc_html__('Link Post Format Option', 'trackngo-core'),
        'post_type' => array('post'),
        'post_formats' => array('link'),
    ));
    CSF::createSection($clinfyx_link_post_format, array(
        // 'title'  => esc_html__('LInk', 'trackngo-core'),
        'fields' => array(
            array(
                'id'      => 'post-link',
                'type'  => 'text',
                'title'   => esc_html__('Link URL', 'trackngo-core'),
                'desc'    => esc_html__('Paste Your URL here', 'trackngo-core'),
                'default' => 'https://google.com',
            ),
        )
    ));



    // Create a metabox for post format link
    $clinfyx_quote_post_format = 'trackngo_post_quote_metabox';
    CSF::createMetabox($clinfyx_quote_post_format, array(
        'title'     => esc_html__('Quote Post Format Option', 'trackngo-core'),
        'post_type' => array('post'),
        'post_formats' => array('quote'),
    ));
    CSF::createSection($clinfyx_quote_post_format, array(
        // 'title'  => esc_html__('quote', 'trackngo-core'),
        'fields' => array(
            array(
                'id'      => 'post-quote-desc',
                'type'  => 'textarea',
                'title'   => esc_html__('Quote Description', 'trackngo-core'),
                'default' => 'Write Your Post Quote Here',
            ),
            array(
                'id'      => 'post-quote-author',
                'type'  => 'text',
                'title'   => esc_html__('Quote Author', 'trackngo-core'),
                'default' => 'Write Your Post Quote Author Name',
            ),
        )
    ));
}
