<?php
class Trackngo_Core_Post_Tags_Widget extends WP_Widget
{
    public function __construct()
    {
        parent::__construct(
            'trackngo_core_post_tags_widget',
            esc_html__('Trackngo Post Tags', 'trackngo-core'),
            array(
                'description' => esc_html__('Post Tags Widget (Markup Preserved)', 'trackngo-core')
            )
        );
    }

    // Frontend Output
    public function widget($args, $instance)
    {
        $title      = !empty($instance['title']) ? $instance['title'] : esc_html__('Tags', 'trackngo-core');
        $taxonomy   = !empty($instance['taxonomy']) ? $instance['taxonomy'] : 'post_tag';
        $number     = !empty($instance['number']) ? absint($instance['number']) : 10;
        $hide_empty = !empty($instance['hide_empty']);
        $order      = !empty($instance['order']) ? $instance['order'] : 'ASC';

        $tags = get_terms(array(
            'taxonomy'   => $taxonomy,
            'number'     => $number,
            'hide_empty' => $hide_empty,
            'order'      => $order,
        ));

        if (empty($tags) || is_wp_error($tags)) {
            return;
        }
?>
        <div class="main-sidebar">
            <div class="single-sidebar-widget">
                <?php if (!empty($title)): ?>
                    <div class="widget-title">
                        <h3><?php echo esc_html($title); ?></h3>
                    </div>
                <?php endif; ?>
                
                <div class="news-widget-categories">
                    <div class="tagcloud">
                        <?php foreach ($tags as $tag) : ?>
                            <a href="<?php echo esc_url(get_term_link($tag)); ?>">
                                <?php echo esc_html($tag->name); ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>

    <?php
    }

    // Backend Form
    public function form($instance)
    {
        $title      = $instance['title'] ?? esc_html__('Tags', 'trackngo-core');
        $taxonomy   = $instance['taxonomy'] ?? 'post_tag';
        $number     = $instance['number'] ?? 10;
        $hide_empty = !empty($instance['hide_empty']);
        $order      = $instance['order'] ?? 'ASC';

        $taxonomies = get_taxonomies(array('public' => true), 'objects');
    ?>
        <p>
            <label><?php esc_html_e('Title:', 'trackngo-core'); ?></label>
            <input class="widefat" type="text"
                name="<?php echo $this->get_field_name('title'); ?>"
                value="<?php echo esc_attr($title); ?>">
        </p>

        <p>
            <label><?php esc_html_e('Taxonomy:', 'trackngo-core'); ?></label>
            <select class="widefat" name="<?php echo $this->get_field_name('taxonomy'); ?>">
                <?php foreach ($taxonomies as $tax) : ?>
                    <option value="<?php echo esc_attr($tax->name); ?>" <?php selected($taxonomy, $tax->name); ?>>
                        <?php echo esc_html($tax->label); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </p>

        <p>
            <label><?php esc_html_e('Number of tags:', 'trackngo-core'); ?></label>
            <input class="tiny-text" type="number"
                name="<?php echo $this->get_field_name('number'); ?>"
                value="<?php echo esc_attr($number); ?>">
        </p>

        <p>
            <label><?php esc_html_e('Order:', 'trackngo-core'); ?></label>
            <select name="<?php echo $this->get_field_name('order'); ?>">
                <option value="ASC" <?php selected($order, 'ASC'); ?>>ASC</option>
                <option value="DESC" <?php selected($order, 'DESC'); ?>>DESC</option>
            </select>
        </p>

        <p>
            <input type="checkbox"
                name="<?php echo $this->get_field_name('hide_empty'); ?>"
                <?php checked($hide_empty); ?>>
            <label><?php esc_html_e('Hide empty tags', 'trackngo-core'); ?></label>
        </p>
<?php
    }

    // Save
    public function update($new, $old)
    {
        return array(
            'title'      => sanitize_text_field($new['title']),
            'taxonomy'   => sanitize_text_field($new['taxonomy']),
            'number'     => absint($new['number']),
            'order'      => sanitize_text_field($new['order']),
            'hide_empty' => !empty($new['hide_empty']),
        );
    }
}
