<?php
class Trackngo_Core_Recent_Post_Widget extends WP_Widget
{
    public function __construct()
    {
        parent::__construct(
            'trackngo_recent_posts_widget',
            esc_html__('Trackngo Recent Posts', 'trackngo-core'),
            array(
                'description' => esc_html__('Recent Posts Widget (Markup Preserved)', 'trackngo-core')
            )
        );
    }

    // Frontend Output
    public function widget($args, $instance)
    {
        $title    = !empty($instance['title']) ? $instance['title'] : esc_html__('Recent Post', 'trackngo-core');
        $number   = !empty($instance['number']) ? absint($instance['number']) : 3;
        $category = !empty($instance['category']) ? absint($instance['category']) : 0;

        $query_args = array(
            'post_type'           => 'post',
            'posts_per_page'      => $number,
            'ignore_sticky_posts' => true,
        );

        if ($category) {
            $query_args['cat'] = $category;
        }

        $recent_query = new WP_Query($query_args);

        if (!$recent_query->have_posts()) {
            return;
        }
?>
        <div class="main-sidebar">
            <div class="single-sidebar-widget">

                <?php if (!empty($title)): ?>
                    <div class="widget-title">
                        <h3><?php echo esc_html($title); ?></h3>
                    </div>
                <?php endif; ?>

                <div class="recent-post-area">
                    <?php while ($recent_query->have_posts()) : $recent_query->the_post(); ?>
                        <div class="recent-items">
                            <div class="recent-thumb">
                                <a href="<?php the_permalink(); ?>">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <?php the_post_thumbnail('thumbnail'); ?>
                                    <?php else : ?>
                                        <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/img/placeholder.png'); ?>" alt="<?php the_title_attribute(); ?>">
                                    <?php endif; ?>
                                </a>
                            </div>

                            <div class="recent-content">
                                <ul>
                                    <li>
                                        <i class="fa-solid fa-calendar-days"></i>
                                        <?php echo esc_html(get_the_date()); ?>
                                    </li>
                                </ul>
                                <h6>
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                </h6>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </div>
    <?php
        wp_reset_postdata();
    }

    // Backend Form
    public function form($instance)
    {
        $title    = $instance['title'] ?? esc_html__('Recent Post', 'trackngo-core');
        $number   = $instance['number'] ?? 3;
        $category = $instance['category'] ?? 0;

        $categories = get_categories();
    ?>
        <p>
            <label><?php esc_html_e('Title:', 'trackngo-core'); ?></label>
            <input class="widefat" type="text"
                name="<?php echo $this->get_field_name('title'); ?>"
                value="<?php echo esc_attr($title); ?>">
        </p>

        <p>
            <label><?php esc_html_e('Number of posts:', 'trackngo-core'); ?></label>
            <input class="tiny-text" type="number"
                name="<?php echo $this->get_field_name('number'); ?>"
                value="<?php echo esc_attr($number); ?>">
        </p>

        <p>
            <label><?php esc_html_e('Filter by category:', 'trackngo-core'); ?></label>
            <select class="widefat" name="<?php echo $this->get_field_name('category'); ?>">
                <option value="0"><?php esc_html_e('All Categories', 'trackngo-core'); ?></option>
                <?php foreach ($categories as $cat) : ?>
                    <option value="<?php echo esc_attr($cat->term_id); ?>" <?php selected($category, $cat->term_id); ?>>
                        <?php echo esc_html($cat->name); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </p>
<?php
    }

    // Save
    public function update($new, $old)
    {
        return array(
            'title'    => sanitize_text_field($new['title']),
            'number'   => absint($new['number']),
            'category' => absint($new['category']),
        );
    }
}
