<?php
class Trackngo_Core_Post_Taxonomy extends WP_Widget
{
    public function __construct()
    {
        parent::__construct(
            'trackngo_core_post_taxonomy_widget',
            esc_html__('Trackngo Post Taxonomy', 'trackngo-core'),
            array(
                'description' => esc_html__('Post Taxonomy Widget', 'trackngo-core')
            )
        );
    }

    // Frontend Output
    public function widget($args, $instance)
    {
        $title      = !empty($instance['title']) ? $instance['title'] : esc_html__('Categories', 'trackngo-core');
        $taxonomy   = !empty($instance['taxonomy']) ? $instance['taxonomy'] : 'category';
        $number     = !empty($instance['number']) ? absint($instance['number']) : 5;
        $hide_empty = !empty($instance['hide_empty']);

        $terms = get_terms(array(
            'taxonomy'   => $taxonomy,
            'number'     => $number,
            'hide_empty' => $hide_empty,
        ));

        if (empty($terms) || is_wp_error($terms)) {
            return;
        }
?>

        <div class="main-sidebar">
            <div class="single-sidebar-widget">

                <?php if (!empty($title)): ?>
                    <div class="widget-title">
                        <h3><?php echo esc_html($title); ?></h3>
                    </div>
                <?php endif; ?>

                <ul class="category-list">
                    <?php foreach ($terms as $term) : ?>
                        <li>
                            <a href="<?php echo esc_url(get_term_link($term)); ?>">
                                <?php echo esc_html($term->name); ?>
                            </a>
                            <span>
                                <i class="fa-solid fa-arrow-up-right"></i>
                            </span>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>

    <?php
    }

    // Backend Form
    public function form($instance)
    {
        $title      = $instance['title'] ?? esc_html__('Categories', 'trackngo-core');
        $taxonomy   = $instance['taxonomy'] ?? 'category';
        $number     = $instance['number'] ?? 5;
        $hide_empty = !empty($instance['hide_empty']);

        $taxonomies = get_taxonomies(array('public' => true), 'objects');
    ?>
        <p>
            <label><?php esc_html_e('Title:', 'trackngo-core'); ?></label>
            <input class="widefat" type="text"
                name="<?php echo $this->get_field_name('title'); ?>"
                value="<?php echo esc_attr($title); ?>">
        </p>

        <p>
            <label><?php esc_html_e('Taxonomy:', 'trackngo-core'); ?></label>
            <select class="widefat" name="<?php echo $this->get_field_name('taxonomy'); ?>">
                <?php foreach ($taxonomies as $tax) : ?>
                    <option value="<?php echo esc_attr($tax->name); ?>" <?php selected($taxonomy, $tax->name); ?>>
                        <?php echo esc_html($tax->label); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </p>

        <p>
            <label><?php esc_html_e('Number of items:', 'trackngo-core'); ?></label>
            <input class="tiny-text" type="number"
                name="<?php echo $this->get_field_name('number'); ?>"
                value="<?php echo esc_attr($number); ?>">
        </p>

        <p>
            <input type="checkbox"
                name="<?php echo $this->get_field_name('hide_empty'); ?>"
                <?php checked($hide_empty); ?>>
            <label><?php esc_html_e('Hide empty categories', 'trackngo-core'); ?></label>
        </p>
<?php
    }

    // Save
    public function update($new, $old)
    {
        return array(
            'title'      => sanitize_text_field($new['title']),
            'taxonomy'   => sanitize_text_field($new['taxonomy']),
            'number'     => absint($new['number']),
            'hide_empty' => !empty($new['hide_empty']),
        );
    }
}
